/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.context;

import java.util.HashSet;
import java.util.Set;
import top.coos.app.context.AppContext;
import top.coos.app.entity.Entity;
import top.coos.app.source.Source;
import top.coos.app.source.SourceFactory;
import top.coos.cache.Cache;
import top.coos.cache.CacheUtil;
import top.coos.util.StringUtil;

public class AppContextCache {
    public static Cache<String, AppContext> CACHE = CacheUtil.newCache();
    public static Cache<String, Set<AppContext>> PRODUCTID_CACHE = CacheUtil.newCache();
    private static Object LOCK = new Object();

    public static AppContext get(String appid) {
        return (AppContext)CACHE.get((Object)appid);
    }

    public static void remove(String appid) {
        CACHE.remove((Object)appid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AppContext getOrLoad(String appid, Source source) {
        String productid;
        AppContext context = AppContextCache.get(appid);
        if (context == null) {
            Object object = LOCK;
            synchronized (object) {
                context = AppContextCache.get(appid);
                if (context == null) {
                    try {
                        if (source == null) {
                            source = SourceFactory.get();
                        }
                        context = source.load(appid);
                        AppContextCache.set(appid, context);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (context != null && context.getApp() != null && !StringUtil.isEmpty((CharSequence)(productid = context.getApp().getProductid()))) {
            HashSet<AppContext> contexts = (HashSet<AppContext>)PRODUCTID_CACHE.get((Object)productid);
            if (contexts == null) {
                contexts = new HashSet<AppContext>();
            }
            contexts.add(context);
            PRODUCTID_CACHE.put((Object)productid, contexts);
        }
        return context;
    }

    public static AppContext set(String appid, AppContext context) {
        CACHE.put((Object)appid, (Object)context);
        return context;
    }

    public static void triggerChange(String appid, Entity entity) {
        Set contexts;
        if (StringUtil.isEmpty((CharSequence)appid) || entity == null) {
            return;
        }
        AppContext context = AppContextCache.get(appid);
        if (context == null || context.getApp() == null) {
            return;
        }
        String productid = context.getApp().getProductid();
        if (!StringUtil.isEmpty((CharSequence)productid) && (contexts = (Set)PRODUCTID_CACHE.get((Object)productid)) != null) {
            for (AppContext appContext : contexts) {
                appContext.onChange(entity);
            }
        }
    }

    public static void triggerDelete(String appid, Entity entity) {
        Set contexts;
        if (StringUtil.isEmpty((CharSequence)appid) || entity == null) {
            return;
        }
        AppContext context = AppContextCache.get(appid);
        if (context == null || context.getApp() == null) {
            return;
        }
        String productid = context.getApp().getProductid();
        if (!StringUtil.isEmpty((CharSequence)productid) && (contexts = (Set)PRODUCTID_CACHE.get((Object)productid)) != null) {
            for (AppContext appContext : contexts) {
                appContext.onDelete(entity);
            }
        }
    }
}

