package top.coos.app.event;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import top.coos.app.enums.ErrorPage;

public class AppEventToErrorPage extends AppEventListener {

	@Override
	public AppEvent getListenerEvent() {

		return AppEvent.TO_ERROR_PAGE;
	}

	@Override
	protected boolean onEvent(Object... objects) {

		ErrorPage page = null;
		HttpServletRequest request = null;
		HttpServletResponse response = null;
		if (objects != null) {
			for (Object object : objects) {
				if (object != null) {
					if (object instanceof HttpServletRequest) {
						request = (HttpServletRequest) object;
					} else if (object instanceof HttpServletResponse) {
						response = (HttpServletResponse) object;
					} else if (object instanceof ErrorPage) {
						page = (ErrorPage) object;
					}
				}
			}
		}
		return toErrorPage(page, request, response);
	}

	public boolean toErrorPage(ErrorPage page, HttpServletRequest request, HttpServletResponse response) {

		if (page == null) {
			return true;
		}
		try {
			switch (page) {
			case NO_PERMISSION:
				request.getRequestDispatcher("/app/error/toNoPermission.do").forward(request, response);
				return false;
			case LOGIN_PLUGIN_NOT_INSTALLED:
				request.getRequestDispatcher("/app/error/toLoginPluginNotInstalled.do")
						.forward(request, response);
				return false;
			case REGISTER_PLUGIN_NOT_INSTALLED:
				request.getRequestDispatcher("/app/error/toRegisterPluginNotInstalled.do")
						.forward(request, response);
				return false;
			case PERMISSION_PLUGIN_NOT_INSTALLED:
				request.getRequestDispatcher("/app/error/toPermissionPluginNotInstalled.do")
						.forward(request, response);
				return false;
			}
			return false;
		} catch (Exception e) {
			e.printStackTrace();
		}
		return false;

	}

}
