package top.coos.app.context;

import java.util.HashSet;
import java.util.Set;

import top.coos.app.context.AppContext;
import top.coos.app.entity.Entity;
import top.coos.app.source.Source;
import top.coos.app.source.SourceFactory;
import top.coos.cache.Cache;
import top.coos.cache.CacheUtil;
import top.coos.util.StringUtil;

public class AppContextCache {

	public static Cache<String, AppContext> CACHE = CacheUtil.newCache();

	public static Cache<String, Set<AppContext>> PRODUCTID_CACHE = CacheUtil.newCache();

	private static Object LOCK = new Object();

	public static AppContext get(String appid) {

		return CACHE.get(appid);
	}

	public static void remove(String appid) {

		CACHE.remove(appid);
	}

	public static AppContext getOrLoad(String appid, Source source) {

		AppContext context = get(appid);
		if (context == null) {
			synchronized (LOCK) {
				context = get(appid);
				if (context == null) {
					try {
						if (source == null) {
							source = SourceFactory.get();
						}
						context = source.load(appid);
						set(appid, context);
					} catch (Exception e) {
						e.printStackTrace();
					}
				}

			}
		}
		if (context != null && context.getApp() != null) {
			String productid = context.getApp().getProductid();
			if (!StringUtil.isEmpty(productid)) {
				Set<AppContext> contexts = PRODUCTID_CACHE.get(productid);
				if (contexts == null) {
					contexts = new HashSet<AppContext>();
				}
				contexts.add(context);
				PRODUCTID_CACHE.put(productid, contexts);
			}
		}
		return context;
	}

	public static AppContext set(String appid, AppContext context) {

		CACHE.put(appid, context);
		return context;
	}

	public static void triggerChange(String appid, Entity entity) {

		if (StringUtil.isEmpty(appid) || entity == null) {
			return;
		}
		AppContext context = get(appid);
		if (context == null || context.getApp() == null) {
			return;
		}
		String productid = context.getApp().getProductid();
		if (!StringUtil.isEmpty(productid)) {
			Set<AppContext> contexts = PRODUCTID_CACHE.get(productid);
			if (contexts != null) {
				for (AppContext appContext : contexts) {
					appContext.onChange(entity);
				}
			}
		}

	}

	public static void triggerDelete(String appid, Entity entity) {

		if (StringUtil.isEmpty(appid) || entity == null) {
			return;
		}
		AppContext context = get(appid);
		if (context == null || context.getApp() == null) {
			return;
		}
		String productid = context.getApp().getProductid();
		if (!StringUtil.isEmpty(productid)) {
			Set<AppContext> contexts = PRODUCTID_CACHE.get(productid);
			if (contexts != null) {
				for (AppContext appContext : contexts) {
					appContext.onDelete(entity);
				}
			}
		}

	}
}
