package top.coos.app.plugin;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

import top.coos.app.entity.plugin.PluginEntity;
import top.coos.app.plugin.Plugin;
import top.coos.cache.Cache;
import top.coos.cache.CacheUtil;
import top.coos.util.FileUtil;
import top.coos.util.ResourceUtil;
import top.coos.util.StringUtil;

public class PluginLoader {

	private static final Cache<String, Plugin> APP_PLUGIN_CACHE = CacheUtil.newCache();

	private static final URLClassLoader URL_CLASS_LOADER = new URLClassLoader(new URL[] {},
			PluginLoader.class.getClassLoader());

	public static Map<File, JarFile> loadLocalJarFiles() {

		Map<File, JarFile> jarFiles = new HashMap<File, JarFile>();
		try {
			InputStream in = ResourceUtil.load("coos.app.plugin.list");
			BufferedReader bf = new BufferedReader(new InputStreamReader(in, "UTF-8"));
			// 最好在将字节流转换为字符流的时候 进行转码
			String line = "";
			while ((line = bf.readLine()) != null) {
				if (!StringUtil.isEmpty(line)) {
					String name = line.trim();
					InputStream stream = ResourceUtil.load(name);
					if (stream != null) {
						byte[] bytes = FileUtil.readBytes(stream);
						File file = ResourceUtil.tempJar(name, bytes);

						JarFile jarFile = loader(URL_CLASS_LOADER, file);
						if (jarFile != null) {
							jarFiles.put(file, jarFile);
						}
					}
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return jarFiles;

	}

	public static JarFile loader(URLClassLoader loader, File jarFile) {

		try {
			if (jarFile != null && jarFile.isFile()) {
				URL url = jarFile.toURI().toURL();// 将File类型转为URL类型，file为jar包路径
				// 得到系统类加载器
				// 因为URLClassLoader中的addURL方法的权限为protected所以只能采用反射的方法调用addURL方法
				Method add = URLClassLoader.class.getDeclaredMethod("addURL", new Class[] { URL.class });
				add.setAccessible(true);
				add.invoke(loader, new Object[] { url });
				return new JarFile(jarFile);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public static String getKey(String name, String version) {

		return name + "-" + version;
	}

	public static String getKey(PluginEntity plugin) {

		return getKey(plugin.getName(), plugin.getVersion());
	}

	public static String getKey(Plugin plugin) {

		return getKey(plugin.getName(), plugin.getVersion());
	}

	public static void loadAppPlugins() {

		APP_PLUGIN_CACHE.clear();
		try {
			Map<File, JarFile> jarFiles = loadLocalJarFiles();
			for (File file : jarFiles.keySet()) {
				Plugin plugin = resolvePlugin(file, jarFiles.get(file));
				if (plugin != null) {
					APP_PLUGIN_CACHE.put(getKey(plugin), plugin);
				}
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static Plugin resolvePlugin(File file, JarFile jarFile) {

		Plugin plugin = null;

		Enumeration<JarEntry> entrys = jarFile.entries();
		while (entrys.hasMoreElements()) {
			JarEntry entry = entrys.nextElement();
			if (entry.isDirectory()) {

			} else {
				String name = entry.getName();
				if (name.endsWith(".class")) {
					try {
						final String class_name = name.substring(0, name.lastIndexOf(".class")).replaceAll("/", ".");
						Class<?> clazz = URL_CLASS_LOADER.loadClass(class_name);
						if (Plugin.class.isAssignableFrom(clazz)) {
							plugin = (Plugin) clazz.newInstance();
						}

					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}
		}
		if (plugin != null) {
			plugin.setJarFilePath(file.getAbsolutePath());
			plugin.loader(URL_CLASS_LOADER);
		}

		return plugin;
	}

	public static Plugin getPlugin(PluginEntity plugin) {

		if (APP_PLUGIN_CACHE.size() == 0) {
			loadAppPlugins();
		}
		String key = getKey(plugin);
		return APP_PLUGIN_CACHE.get(key);
	}

	public static List<Plugin> getAppPlugins() {

		if (APP_PLUGIN_CACHE.size() == 0) {
			loadAppPlugins();
		}
		List<Plugin> plugins = new ArrayList<Plugin>();
		for (String key : APP_PLUGIN_CACHE.keySet()) {
			plugins.add(APP_PLUGIN_CACHE.get(key));
		}
		return plugins;
	}
}
