(function() {
	app.wechat = app.wechat || new Object();
	app.wechat.app = app.wechat.app || new Object();
	app.wechat.app.buildBox = function(options) {
		var setting = {
			size : 'sm',
			url : '/wechat/manager/app/queryPage.do',
			form : {
				inputs : [ {
					label : '名称',
					name : 'name',
					size : 4
				}, {
					label : 'AppId',
					name : 'appid',
					size : 4
				} ],
				btns : [ {
					html : '<div class="coos-btn coos-btn-xs coos-green">搜索</div>',
					isSearch : true
				} ]
			},
			table : {
				cols : [ {
					text : 'AppId',
					name : 'appid'
				}, {
					text : '名称',
					name : 'name'
				} ],
				page : true
			}
		};

		if (options) {
			if (options.form) {
				$(options.form.btns).each(function(index, btn) {
					setting.form.btns.push(btn);
				});
			}
			$(options.table.cols).each(function(index, col) {
				setting.table.cols.push(col);
			});
		}
		return coos.buildBox(setting);
	};
	app.wechat.app.initIndexPage = function() {

		var build = app.wechat.app.buildBox({
			form : {
				btns : [ {
					html : '<div class="coos-btn coos-btn-xs coos-orange mgl-5">添加</div>',
					onClick : function() {
						app.wechat.app.initForm('添加');
					}
				} ]
			},
			table : {
				cols : [ {
					text : '操作',
					btns : [ {
						html : '<div class="coos-btn coos-btn-xs coos-orange ">修改</div>',
						onClick : function(one) {
							app.wechat.app.initForm('编辑', one);
						}
					}, {
						html : '<div class="coos-btn coos-btn-xs coos-red mgl-5">删除</div>',
						onClick : function(data) {
							coos.box.confirm('删除后该记录将无法恢复，确定删除？', function() {
								coos.post('/wechat/manager/app/delete.do', {
									recordid : data.appid
								}, function(result) {
									result = result || {};
									if (result.errcode == 0) {
									} else {
										coos.box.error(result.errmsg);
									}
									app.wechat.app.initIndexPage();
								});
							});
						}
					} ]
				} ]
			}
		});
		$('.wechat-app-list-box').empty();
		$('.wechat-app-list-box').append(build.$box);
		app.wechat.app.initForm('添加');
	};

	app.wechat.app.initForm = function(title, data, callback) {
		title = title || '编辑';
		$('.wechat-app-form-title').html(title);
		var $box = $('.wechat-app-form-box');
		$box.empty();

		var $form = $('<div class="coos-form coos-input-sm"/>');
		$box.append($form);

		$form.append('<input name="appid" required="1" input-skin="0" label="AppId" info="" class="coos-input " />');
		$form.append('<input name="name" required="1" input-skin="0" label="名称" info="" class="coos-input " />');
		$form.append('<input name="secret" required="1" input-skin="0" label="Secret" info="" class="coos-input " />');
		$form.append('<input name="icon" input-skin="0" label="图片" class="coos-input coos-input-file-image " />');

		coos.format.init($form);

		coos.form.full($form, data, true);

		var $btnBox = $('<div class="coos-row mg-10"/>');

		$box.append($btnBox);

		var $btn = $('<div class="coos-btn coos-btn-sm coos-bg-green">保存</div>');
		$btn.click(function() {
			var result = coos.form.validate($form);
			if (result.valid) {
				var data = coos.form.getData($form);
				coos.post('/wechat/manager/app/save.do', data, function(result) {
					result = result || {};
					if (result.errcode == 0) {
					} else {
						coos.box.error(result.errmsg);
					}
					app.wechat.app.initIndexPage();
				});
			}
		});
		$btnBox.append($btn);
	};

	app.wechat.app.createPageBox = function(options) {
		var setting = {
			size : 'sm',
			form : {},

			url : '/wechat/manager/app/queryPage.do',
		};
		if (options) {
			if (options.form) {
				$(options.form.btns).each(function(index, btn) {
					setting.form.btns.push(btn);
				});
			}
			$(options.cols).each(function(index, col) {
				setting.cols.push(col);
			});
		}
		var $box = coos.table.build(setting);
		return $box;
	};
})();