package top.coos.app.handler;

import top.coos.app.entity.AppEntity;
import top.coos.app.entity.BaseAppEntity;
import top.coos.app.entity.BaseProductEntity;
import top.coos.app.entity.ProductEntity;

public class EntityHandler {

	public static boolean mustAccountcode(Class<?> clazz) {

		if (clazz.equals(AppEntity.class) || clazz.equals(ProductEntity.class)) {
			return true;
		}
		return false;
	}

	public static boolean mustAppid(Class<?> clazz) {

		if (BaseAppEntity.class.isAssignableFrom(clazz)) {
			return true;
		}
		return false;
	}

	public static boolean mustProductid(Class<?> clazz) {

		if (BaseProductEntity.class.isAssignableFrom(clazz)) {
			return true;
		}
		return false;
	}

}
