package top.coos.app.handler;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import top.coos.app.Application;
import top.coos.app.bean.service.ServiceBean;
import top.coos.app.factory.IFaceFactory;
import top.coos.app.ifaces.IProcessorHelper;
import top.coos.bean.ParamBean;
import top.coos.util.RequestUtil;
import top.coos.util.StringUtil;

public class ProcessorHandler {

	public static Object processService(Application application, String serviceid, HttpServletRequest request)
			throws Exception {

		ServiceBean<?> service = application.getService(serviceid);
		return processService(application, service, request);
	}

	public static Object processService(Application application, ServiceBean<?> service, HttpServletRequest request)
			throws Exception {

		Map<String, String> requestParam = RequestUtil.getRequestMap(request);
		String requestBody = RequestUtil.getStringContent(request);
		if (StringUtil.isEmpty(requestBody)) {
			if (requestParam != null && requestParam.size() > 0) {
				for (String key : requestParam.keySet()) {
					if (key.indexOf("{") == 0 || key.indexOf("[") == 0) {
						requestBody = key;
						requestParam.remove(key);
						break;
					}
				}
			}
		}
		Map<String, Object> cache = new HashMap<String, Object>();
		ParamBean param = new ParamBean(requestParam, cache, requestBody);
		return processService(application, service, param);
	}

	public static Object processService(Application application, String serviceid, ParamBean param)
			throws Exception {

		ServiceBean<?> service = application.getService(serviceid);
		return processService(application, service, param);
	}

	public static Object processServiceByName(Application application, String servicename, ParamBean param)
			throws Exception {

		ServiceBean<?> service = application.getServiceByName(servicename);
		return processService(application, service, param);
	}

	public static Object processService(Application application, ServiceBean<?> service, ParamBean param)
			throws Exception {

		IProcessorHelper helper = IFaceFactory.getProcessorHelper();
		return helper.process(application, service, param);
	}
}
