package top.coos.app.plugin;

import java.io.InputStream;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

import javax.persistence.Table;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;

import top.coos.app.Application;
import top.coos.app.bean.InputBean;
import top.coos.app.bean.UrlBean;
import top.coos.app.event.AppEventListener;
import top.coos.cache.Cache;
import top.coos.cache.CacheUtil;
import top.coos.util.FileUtil;
import top.coos.util.ResourceUtil;

public abstract class Plugin {

	protected final String name = getName();

	protected final String version = getVersion();

	protected final String remark = getDescription();

	protected final List<InputBean> inputs = getInputs();

	protected final List<UrlBean> urls = getUrls();

	public abstract String getName();

	public abstract String getVersion();

	public abstract String getDescription();

	public String jarName;

	public List<RelyPlugin> rely_plugins = getRely();

	public final Set<Class<?>> table_classs = new HashSet<Class<?>>();

	public final Set<Class<?>> app_event_listener_classs = new HashSet<Class<?>>();

	public final Set<Class<?>> servlet_classs = new HashSet<Class<?>>();

	public final Cache<String, byte[]> resources = CacheUtil.newCache();

	public Plugin addClass(Class<?> clazz) {

		if (clazz.isAnnotationPresent(Table.class)) {
			table_classs.add(clazz);
		}
		if (AppEventListener.class.isAssignableFrom(clazz)) {
			app_event_listener_classs.add(clazz);
		}
		if (HttpServlet.class.isAssignableFrom(clazz) && clazz.isAnnotationPresent(WebServlet.class)) {
			servlet_classs.add(clazz);
		}
		return this;
	}

	public void initializationData(Application application) {

	}

	public List<InputBean> getInputs() {

		return new ArrayList<InputBean>();
	}

	public List<UrlBean> getUrls() {

		return new ArrayList<UrlBean>();
	}

	public JarFile loader(URLClassLoader loader) {

		table_classs.clear();
		app_event_listener_classs.clear();
		servlet_classs.clear();
		resources.clear();

		try {
			JarFile jarFile = PluginLoader.loader(loader, this);
			if (jarFile != null) {
				resolve(loader, jarFile);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	public Plugin resolve(URLClassLoader loader, JarFile jarFile) {

		Enumeration<JarEntry> entrys = jarFile.entries();
		while (entrys.hasMoreElements()) {
			JarEntry entry = entrys.nextElement();
			if (entry.isDirectory()) {

			} else {
				String name = entry.getName();
				if (name.endsWith(".class")) {
					try {
						final String class_name = name.substring(0, name.lastIndexOf(".class")).replaceAll("/", ".");
						Class<?> clazz = loader.loadClass(class_name);
						addClass(clazz);
					} catch (Exception e) {
						e.printStackTrace();
					}
				} else {
					InputStream stream = ResourceUtil.load(loader, name);
					if (stream != null) {
						try {
							addResources(name, FileUtil.readBytes(stream));
						} catch (Exception e) {
							e.printStackTrace();
						}
					}
				}
			}
		}
		return this;
	}

	public Plugin addResources(String name, byte[] bytes) {

		resources.put(name, bytes);
		return this;
	}

	public List<RelyPlugin> getRely() {

		return new ArrayList<RelyPlugin>();
	}

}
