package top.coos.app.source;

import top.coos.app.configuration.SourceConfiguration;
import top.coos.app.configuration.SourceConfiguration.Source.Elasticsearch;
import top.coos.app.enums.SourceType;
import top.coos.resource.handler.ResourceHandler;
import top.coos.util.StringUtil;

public class SourceFactory {

	private static Source SOURCE;

	public static Source get() {

		if (SOURCE != null) {
			return SOURCE;
		}

		SourceConfiguration configuration = new SourceConfiguration();
		if (configuration.getSource() != null) {
			SourceType type = SourceType.LOCAL;
			if (!StringUtil.isEmpty(configuration.getSource().getType())) {
				type = SourceType.valueOf(configuration.getSource().getType());
			}
			switch (type) {
			case LOCAL:
				try {
					SOURCE = ResourceHandler.getBean(LocalSource.class);
				} catch (Exception e) {
					e.printStackTrace();
				}
				break;
			case ES:

				try {
					SOURCE = ResourceHandler.getBean(ESSource.class);
					Elasticsearch elasticsearch = configuration.getSource().getElasticsearch();
					((ESSource) SOURCE).init(elasticsearch);
				} catch (Exception e) {
					e.printStackTrace();
				}
				break;
			default:
				throw new RuntimeException(configuration.getSource().getType() + " source does not exist!");
			}
		}
		return SOURCE;
	}
}
