/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.factory;

import java.sql.SQLException;
import top.coos.app.Application;
import top.coos.bean.Database;
import top.coos.cache.Cache;
import top.coos.cache.CacheUtil;
import top.coos.db.ds.DSFactory;
import top.coos.service.Service;
import top.coos.service.dynamic.DynamicService;

public class ServiceFactory {
    static final Cache<String, Database> DATABASE_CACHE = CacheUtil.newCache();

    private static String getDatabaseKey(Application application, String name) {
        String key = "";
        if (application.getProductId() != null) {
            key = key + application.getProductId();
        }
        key = key + "-" + name;
        return key;
    }

    public static final DSFactory get(Application application, String name) throws Exception {
        if (application == null) {
            throw new Exception("application is null.");
        }
        String key = ServiceFactory.getDatabaseKey(application, name);
        if (DATABASE_CACHE.get((Object)key) == null) {
            Database database = application.getDatabaseByName(name);
            DATABASE_CACHE.put((Object)key, (Object)database);
        }
        return DSFactory.get((Database)((Database)DATABASE_CACHE.get((Object)key)));
    }

    public static final Service getService(Application application, String name) throws Exception {
        return ServiceFactory.getService(ServiceFactory.get(application, name));
    }

    public static final Service getService(Database database) throws SQLException {
        return ServiceFactory.getService(DSFactory.get((Database)database));
    }

    public static final Service getService(DSFactory factory) {
        return new DynamicService(factory);
    }
}

