var app = window.app || new Object();
(function() {
	var APP_LOADED = false;
	var BODY_LOADED = false;
	var APP_READY = false;
	document.writeln('<link rel="stylesheet" type="text/css" href="' + _RESOURCE_URL + 'app/main.css' + '" />');
	var $box = $('<div class="coos-app-loading-box"></div>');
	var html = '';
	html += '<div class="coos-loading-box">';
	html += '<div class="coos-loading coos-loading-oval"></div>';
	html += '</div>';
	html = '';
	html += '<div class="coos-app-loading">';
	html += '<div class="coos-app-loading-progress-bar-box">';
	html += '<div class="coos-app-loading-progress-bar">';
	html += '</div>';
	html += '</div>';
	html += '<div class="coos-app-loading-text">';
	html += 'Loading';
	html += '</div>';
	html += '</div>';

	$box.append(html);

	var $html = $('html');
	$html.prepend($box);

	$.ajax({
		url : coos.url.format('/coos/app/data/get'),
		data : {},
		type : 'post',
		dataType : 'json',
		beforeSend : function() {
		},
		success : function(result) {
			result = result || {};
			init(result.value);
		},
		complete : function(XMLHttpRequest, textStatus) {
		},
		error : function(XMLHttpRequest, textStatus, errorThrown) {
		}
	});
	app.source = {};
	var init = function(map) {
		map = map || {};
		app.source.APP_INFO = map.APP_INFO || {};
		app.source.APP_RESOURCES = map.APP_RESOURCES || [];
		app.source.APP_THEMES = map.APP_THEMES || [];
		app.source.APP_SESSION = map.APP_SESSION || {};
		app.source.APP_PLUGIN = map.APP_PLUGIN || {};
		app.source.SERVER_INFO = map.SERVER_INFO || {};
		app.source.IS_DEV = map.IS_DEV;
		APP_LOADED = true;
		initResource(app.source.APP_RESOURCES, function() {
			ready();
		});

	};
	document.writeln('<style id="APP-RESOURCE-STYLE" type="text/css"></style>');

	var initResource = function(resources, callback) {
		var res = [];
		$(resources).each(function(index, resource) {
			if (coos.isEmpty(resource.type)) {
				return;
			}
			if (!coos.isTrue(resource.common)) {
				return;
			}
			res.push(resource);
		});
		coos.plugin.loadResource(res, callback);
	};

	app.page = new Object();
	app.page.build = function(page, callback) {
		page = page || {};
		var resources = [];
		try {
			var importresources = [];
			if (!coos.isEmpty(page.importresources)) {
				importresources = JSON.parse(page.importresources);
			}
			$(importresources).each(function(index, importresource) {
				$(app.source.APP_RESOURCES).each(function(index, resource) {
					if (resource && resource.id && resource.id == importresource) {
						resources.push(resource);
					}
				});
			});
		} catch (e) {
		}
		if (!coos.isEmpty(page.importcss)) {
			resources.push({
				type : 'FILE',
				name : page.importcss,
				file : page.importcss
			});
		}
		if (!coos.isEmpty(page.importjs)) {
			resources.push({
				type : 'FILE',
				name : page.importjs,
				file : page.importjs
			});
		}
		coos.plugin.loadResource(resources, function() {
			var pageObject = coos.page({
				layout : page
			});

			var $box = page.$box;
			if (page.$box == null && app.frame && app.frame.$pagebox) {
				$box = app.frame.$pagebox;
			}
			if ($box == null) {
				$box = $('.coos-page-context');
				if ($box.length == 0) {
					$box = $('<div class="coos-page-context"/>');
					$('body').append($box);
				}

			}
			$box = $($box);
			$box.empty();
			pageObject.build($box, function() {
				if (callback) {
					callback(pageObject);
				}
			});
		});
	};
	var time = 100;
	var start = new Date().getTime();

	function ready() {
		if (!APP_LOADED || !BODY_LOADED) {
			return;
		}
		if (APP_READY) {
			return;
		}
		APP_READY = true;
		app.frame = coos.frame({
			themes : app.source.APP_THEMES
		});
		app.frame.build();
		var end = new Date().getTime();
		$box.addClass('coos-hide');
		window.setTimeout(function() {
			$(ready_callbacks).each(function(index, ready_callback) {
				ready_callback && ready_callback();
			});
		}, time - (end - start));
	}

	var ready_callbacks = [];
	app.ready = function(callback) {
		if (APP_READY) {
			callback && callback();
			return;
		}
		ready_callbacks.push(callback);
	};
	$(function() {
		BODY_LOADED = true;
		ready();
	});

})();