package top.coos.app.enums;

public enum InputType implements ValueAndText {

	TEXT("TEXT", "TEXT"),

	PASSWORD("PASSWORD", "PASSWORD"),

	SELECT("SELECT", "SELECT"),

	CHECKBOX("CHECKBOX", "CHECKBOX"),

	CHECKBOX_TAG("CHECKBOX-TAG", "CHECKBOX-TAG"),

	RADIO("RADIO", "RADIO"),

	RADIO_TAG("RADIO-TAG", "RADIO-TAG"),

	SWITCH("SWITCH", "SWITCH"),

	DATE("DATE", "DATE"),

	TIME("TIME", "TIME"),

	DATETIME("DATETIME", "DATETIME"),

	SLIDER("SLIDER", "SLIDER"),

	COLOR("COLOR", "COLOR"),

	FILE("FILE", "FILE"),

	FILE_IMAGE("FILE-IMAGE", "FILE-IMAGE"),

	TEXTAREA("TEXTAREA", "TEXTAREA"),

	EDITOR("EDITOR", "EDITOR"),

	CODE_EDITOR("CODE-EDITOR", "CODE-EDITOR");

	private InputType(String value, String text) {

		this.value = value;
		this.text = text;
	}

	private final String value;

	private final String text;

	public String getValue() {

		return value;
	}

	public String getText() {

		return text;
	}
}
