package top.coos.app.factory;

import java.util.Map;

import top.coos.app.enums.DataType;
import top.coos.bean.result.FileResultBean;
import top.coos.bean.result.JSONResultBean;
import top.coos.bean.result.ObjectResultBean;
import top.coos.bean.result.PageResultBean;
import top.coos.bean.result.ResultBean;
import top.coos.bean.result.StringResultBean;

public class ResultFactory {

	public static ResultBean<?> get(DataType type) {

		ResultBean<?> result = null;
		switch (type) {
		case JSON:
			result = new JSONResultBean();
			break;
		case PAGE:
			result = new PageResultBean<Map<String, Object>>();
			break;
		case XML:
			result = new StringResultBean();
			break;
		case HTML:
			result = new StringResultBean();
			break;
		case FILE:
			result = new FileResultBean();
			break;
		case OTHER:
			result = new ObjectResultBean();
			break;
		}
		return result;
	}

}
