package top.coos.app.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import javax.servlet.http.HttpServlet;

import top.coos.Configuration;
import top.coos.ConfigurationFactory;
import top.coos.app.factory.ApplicationFactory;
import top.coos.resource.handler.ResourceHandler;
import top.coos.util.StringUtil;

public class AppServletContext {

	public static ServletContext CONTEXT;

	public static void initialize(ServletContext context) {

		if (CONTEXT != null) {
			return;
		}
		if (context == null) {
			throw new RuntimeException("context is null.");
		}
		CONTEXT = context;
		init();
	}

	private static void init() {

		try {

			// AppFilter filter = new AppFilter();
			// String name = AppFilter.class.getName();
			// FilterRegistration appFilter = CONTEXT.addFilter(name, (Filter)
			// filter);
			// EnumSet<DispatcherType> dispatcherTypes =
			// EnumSet.allOf(DispatcherType.class);
			// dispatcherTypes.add(DispatcherType.REQUEST);
			// dispatcherTypes.add(DispatcherType.FORWARD);
			//
			// appFilter.addMappingForUrlPatterns(dispatcherTypes, true, "/*");
			// CONTEXT.setAttribute("APP_FILTER_REGISTRATION", appFilter);

			AppControlServlet servlet = ResourceHandler.getBean(AppControlServlet.class);
			String name = AppControlServlet.class.getName();
			ServletRegistration appControl = CONTEXT.addServlet(name, (HttpServlet) servlet);
			CONTEXT.setAttribute("APP_CONTROL_SERVLET_REGISTRATION", appControl);

			// 设置AppContext
			Configuration configuration = ConfigurationFactory.get();
			if (configuration != null && !StringUtil.isEmpty(configuration.getAppid())) {
				ApplicationFactory.get(CONTEXT);
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static void addAppControl(String... path) {

		if (CONTEXT == null) {
			return;
		}
		ServletRegistration registration = (ServletRegistration) CONTEXT.getAttribute("APP_CONTROL_SERVLET_REGISTRATION");
		registration.addMapping(path);

	}

	// public static void addAppFilter(String... path) {
	//
	// if (CONTEXT == null) {
	// return;
	// }
	// FilterRegistration registration = (FilterRegistration)
	// CONTEXT.getAttribute("APP_FILTER_REGISTRATION");
	// registration.addMappingForUrlPatterns(null, true, path);
	// }

}
