/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import top.coos.app.Application;
import top.coos.app.context.AppContext;
import top.coos.app.entity.cache.CacheEntity;
import top.coos.app.handler.ProcessorHandler;
import top.coos.app.session.AppSession;
import top.coos.bean.ParamBean;
import top.coos.util.ObjectUtil;
import top.coos.util.StringUtil;

public class CacheHandler {
    public static List<CacheEntity> getCaches(Application application) {
        AppContext context = application.getAppContext();
        if (context != null && context.getCaches() != null) {
            return context.getCaches();
        }
        return new ArrayList<CacheEntity>();
    }

    public static void cache(Application application, AppSession session) {
        List<CacheEntity> caches = CacheHandler.getCaches(application);
        for (CacheEntity cache : caches) {
            CacheHandler.cache(application, session, cache);
        }
    }

    public static void refreshLoginCache(Application application, AppSession session) {
        List<CacheEntity> caches = CacheHandler.getCaches(application);
        for (CacheEntity cache : caches) {
            if (!cache.isAfterlogin()) continue;
            session.removeCached(cache);
            CacheHandler.cache(application, session, cache);
        }
    }

    private static void cache(Application application, AppSession session, CacheEntity cache) {
        if (session == null) {
            return;
        }
        if (StringUtil.isEmpty((CharSequence)cache.getName())) {
            return;
        }
        if (session.isCached(cache)) {
            return;
        }
        if (!session.isLogin() && cache.isAfterlogin()) {
            return;
        }
        Object value = null;
        String serviceid = cache.getServiceid();
        if (!StringUtil.isEmpty((CharSequence)serviceid)) {
            ParamBean param = new ParamBean(null, (Map)session.getCache(), null);
            try {
                JSONObject res;
                value = ProcessorHandler.processService(application, serviceid, param);
                if (value != null && (res = (JSONObject)JSONObject.toJSON((Object)value)).get((Object)"value") != null) {
                    value = res.get((Object)"value") instanceof List ? res.getJSONArray("value") : res.getJSONObject("value");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        session.set(cache.getName(), value);
        session.setCached(cache);
        if (value != null && value instanceof List) {
            CacheHandler.refreshSelected(application, session, cache.getName(), null);
        }
    }

    public static void refreshSelected(Application application, AppSession session, String cachename, String selectedvalue) {
        if (application == null || session == null || StringUtil.isEmpty((CharSequence)cachename)) {
            return;
        }
        List<CacheEntity> caches = CacheHandler.getCaches(application);
        CacheEntity cache = null;
        for (CacheEntity c : caches) {
            if (StringUtil.isEmpty((CharSequence)c.getName()) || !c.getName().equals(cachename)) continue;
            cache = c;
            break;
        }
        if (cache != null && !StringUtil.isEmpty((CharSequence)cache.getSelectedcachename())) {
            Object cacheValue = session.get(cache.getName());
            String selectedcachename = cache.getSelectedcachename();
            String valuename = cache.getValuename();
            Object selectedValue = null;
            Object firstValue = null;
            if (cacheValue != null && !StringUtil.isEmpty((CharSequence)valuename) && cacheValue instanceof List) {
                JSONArray array = (JSONArray)JSONArray.toJSON((Object)cacheValue);
                if (array.size() > 0) {
                    firstValue = array.getJSONObject(0);
                }
                for (int i = 0; i < array.size(); ++i) {
                    JSONObject one = array.getJSONObject(i);
                    Object value = one.get((Object)valuename);
                    if (!ObjectUtil.equal((Object)value, (Object)selectedvalue)) continue;
                    selectedValue = one;
                    break;
                }
            }
            if (selectedValue == null) {
                selectedValue = firstValue;
            }
            if (selectedValue != null) {
                String json = JSONObject.toJSONString(selectedValue, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect});
                selectedValue = JSONObject.parse((String)json);
            }
            session.set(selectedcachename, JSON.toJSON(selectedValue));
        }
    }
}

