/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.session;

import com.alibaba.fastjson.JSONObject;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import top.coos.app.Application;
import top.coos.app.bean.UserBean;
import top.coos.app.entity.cache.CacheEntity;
import top.coos.cache.Cache;
import top.coos.cache.CacheUtil;
import top.coos.factory.LogFactory;
import top.coos.util.StringUtil;

public class AppSession {
    static Logger log = LogFactory.get();
    private final HttpSession session;
    private final Application application;
    private boolean login;
    private UserBean user;
    private final JSONObject cache = new JSONObject();
    private final Cache<String, Boolean> CACHED = CacheUtil.newCache();

    public AppSession(HttpSession session, Application application) {
        this.session = session;
        this.application = application;
        if (application != null) {
            application.triggerNewSession(this);
        }
    }

    public HttpSession getSession() {
        return this.session;
    }

    public boolean isLogin() {
        return this.login;
    }

    public void doLogin(UserBean user) {
        this.user = user;
        this.login = true;
        if (user != null && this.application != null) {
            this.application.triggerLogin(this);
        }
    }

    public void doLogout() {
        this.user = null;
        this.login = false;
        if (this.application != null) {
            this.application.triggerLogout(this);
        }
    }

    public UserBean getUser() {
        return this.user;
    }

    public Application getApplication() {
        return this.application;
    }

    public JSONObject getCache() {
        return this.cache;
    }

    public void set(String key, Object value) {
        this.cache.put(key, value);
    }

    public Object get(String key) {
        return this.cache.get((Object)key);
    }

    public static String getTimestampKey(CacheEntity cache) {
        String key = cache.getName();
        String time = cache.getLastupdatetime();
        if (StringUtil.isEmpty((CharSequence)time)) {
            time = "0";
        }
        key = key + "-" + time;
        return key.toUpperCase();
    }

    public boolean isCached(CacheEntity cache) {
        String key = AppSession.getTimestampKey(cache);
        return this.CACHED.get((Object)key) != null;
    }

    public void setCached(CacheEntity cache) {
        String key = AppSession.getTimestampKey(cache);
        this.CACHED.put((Object)key, (Object)true);
    }

    public void removeCached(CacheEntity cache) {
        String key = AppSession.getTimestampKey(cache);
        this.CACHED.remove((Object)key);
    }
}

