/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.source;

import top.coos.app.configuration.SourceConfiguration;
import top.coos.app.enums.SourceType;
import top.coos.app.source.ESSource;
import top.coos.app.source.LocalSource;
import top.coos.app.source.Source;
import top.coos.resource.handler.ResourceHandler;
import top.coos.util.StringUtil;

public class SourceFactory {
    private static Source SOURCE;

    public static Source get() {
        if (SOURCE != null) {
            return SOURCE;
        }
        SourceConfiguration configuration = new SourceConfiguration();
        if (configuration.getSource() != null) {
            SourceType type = SourceType.LOCAL;
            if (!StringUtil.isEmpty((CharSequence)configuration.getSource().getType())) {
                type = SourceType.valueOf(configuration.getSource().getType());
            }
            switch (type) {
                case LOCAL: {
                    try {
                        SOURCE = (Source)ResourceHandler.getBean(LocalSource.class);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case ES: {
                    try {
                        SOURCE = (Source)ResourceHandler.getBean(ESSource.class);
                        SourceConfiguration.Source.Elasticsearch elasticsearch = configuration.getSource().getElasticsearch();
                        ((ESSource)SOURCE).init(elasticsearch);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                default: {
                    throw new RuntimeException(configuration.getSource().getType() + " source does not exist!");
                }
            }
        }
        return SOURCE;
    }
}

