package top.coos.app.enums;

import top.coos.util.StringUtil;

public enum ComparisonOperator {

	EQ("=", "等于"),

	NEQ("<>", "不等于"),

	GT(">", "大于"),

	LT("<", "小于"),

	GTE(">=", "大于等于"),

	LTE("<=", "小于等于"),

	LIKE("LIKE", "前后模糊匹配"),

	LIKE_AFTER("LIKE%", "后模糊匹配"),

	LIKE_BEFORE("%LIKE", "前模糊匹配"),

	IN("IN", "包含"),

	IN_LIKE("IN LIKE", "包含模糊匹配"),

	NOT_IN("NOT IN", "不包含");

	public static ComparisonOperator get(String value) {

		if (StringUtil.isEmpty(value)) {
			return ComparisonOperator.EQ;
		}
		ComparisonOperator comparisonOperator = null;

		for (ComparisonOperator one : ComparisonOperator.values()) {
			if (one.getValue().equalsIgnoreCase(value) || one.toString().equalsIgnoreCase(value)) {
				comparisonOperator = one;
				break;
			}
		}
		if (comparisonOperator == null) {
			return ComparisonOperator.EQ;
		}
		return comparisonOperator;
	}

	private ComparisonOperator(String value, String text) {

		this.value = value;
		this.text = text;
	}

	private String value;

	private String text;

	public String getValue() {

		return value;
	}

	public void setValue(String value) {

		this.value = value;
	}

	public String getText() {

		return text;
	}

	public void setText(String text) {

		this.text = text;
	}

}
