package top.coos.app.bean;

import java.util.ArrayList;
import java.util.List;

public class InputBean {

	private String name;
	private String label;
	private String type;
	private String info;
	private List<OptionBean> options = new ArrayList<OptionBean>();

	public InputBean(String name, String label) {

		this.name = name;
		this.label = label;
	}

	public InputBean(String name, String label, String type) {

		this.name = name;
		this.label = label;
		this.type = type;
	}

	public InputBean addOption(OptionBean option) {

		if (options == null) {
			options = new ArrayList<OptionBean>();
		}
		options.add(option);
		return this;
	}

	public List<OptionBean> getOptions() {

		return options;
	}

	public void setOptions(List<OptionBean> options) {

		this.options = options;
	}

	public String getName() {

		return name;
	}

	public void setName(String name) {

		this.name = name;
	}

	public String getLabel() {

		return label;
	}

	public void setLabel(String label) {

		this.label = label;
	}

	public String getType() {

		return type;
	}

	public void setType(String type) {

		this.type = type;
	}

	public String getInfo() {

		return info;
	}

	public void setInfo(String info) {

		this.info = info;
	}

}
