package top.coos.app.event;

import top.coos.app.handler.CacheHandler;
import top.coos.app.session.AppSession;

public class AppEventCacheAfterLogin extends AppEventListener {

	@Override
	public AppEvent getListenerEvent() {

		return AppEvent.LOGIN;
	}

	@Override
	protected boolean onEvent(Object... objects) {

		AppSession session = null;
		if (objects != null) {
			for (Object object : objects) {
				if (object != null)
				{
					if (object instanceof AppSession) {
						session = (AppSession) object;
					}
				}
			}
		}
		if (session != null) {
			CacheHandler.refreshLoginCache(application, session);
		}
		return true;
	}

}
