package top.coos.app.session;

import javax.servlet.http.HttpSession;

import org.slf4j.Logger;

import com.alibaba.fastjson.JSONObject;

import top.coos.app.Application;
import top.coos.app.bean.UserBean;
import top.coos.app.entity.cache.CacheEntity;
import top.coos.cache.Cache;
import top.coos.cache.CacheUtil;
import top.coos.factory.LogFactory;
import top.coos.util.StringUtil;

public class AppSession {

	public static final String SESSION_LOGIN_USER_KEY = "LOGIN_USER";

	static Logger log = LogFactory.get();

	private final HttpSession session;

	private final Application application;

	private boolean login;

	private UserBean user;

	private final JSONObject cache = new JSONObject();

	private final Cache<String, Boolean> CACHED = CacheUtil.newCache();

	public AppSession(HttpSession session, Application application) {

		this.session = session;
		this.application = application;

		if (application != null) {
			application.triggerNewSession(this);
		}
	}

	public HttpSession getSession() {

		return session;
	}

	public boolean isLogin() {

		return login;
	}

	public void doLogin(UserBean user) {

		this.user = user;
		this.login = true;
		set(SESSION_LOGIN_USER_KEY, user);
		if (user != null && application != null) {
			application.triggerLogin(this);
		}
	}

	public void doLogout() {

		this.user = null;
		this.login = false;
		set(SESSION_LOGIN_USER_KEY, null);
		if (application != null) {
			application.triggerLogout(this);
		}
	}

	public UserBean getUser() {

		return user;
	}

	public Application getApplication() {

		return application;
	}

	public JSONObject getCache() {

		return cache;
	}

	public void set(String key, Object value) {

		this.cache.put(key, value);
	}

	public Object get(String key) {

		return this.cache.get(key);
	}

	public static String getTimestampKey(CacheEntity cache) {

		String key = cache.getName();
		String time = cache.getLastupdatetime();
		if (StringUtil.isEmpty(time)) {
			time = "0";
		}
		key += "-" + time;
		return key.toUpperCase();

	}

	public boolean isCached(CacheEntity cache) {

		String key = getTimestampKey(cache);
		if (CACHED.get(key) != null) {
			return true;
		}
		return false;
	}

	public void setCached(CacheEntity cache) {

		String key = getTimestampKey(cache);
		CACHED.put(key, true);
	}

	public void removeCached(CacheEntity cache) {

		String key = getTimestampKey(cache);
		CACHED.remove(key);
	}
}
