/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.bean;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import top.coos.app.session.AppSession;
import top.coos.app.session.AppSessionHandler;
import top.coos.util.RequestUtil;
import top.coos.util.StringUtil;

public class ParamBean {
    private final Map<String, String> requestParam;
    private final JSON requestBody;
    private final Map<String, Object> cache;
    private final AppSession session;

    public ParamBean(HttpServletRequest request) {
        Map requestParam = RequestUtil.getRequestMap((HttpServletRequest)request);
        String requestBody = RequestUtil.getStringContent((HttpServletRequest)request);
        if (StringUtil.isEmpty((CharSequence)requestBody) && requestParam != null && requestParam.size() > 0) {
            for (String key : requestParam.keySet()) {
                if (key.indexOf("{") != 0 && key.indexOf("[") != 0) continue;
                requestBody = key;
                requestParam.remove(key);
                break;
            }
        }
        AppSession session = AppSessionHandler.get(request);
        this.requestParam = requestParam;
        this.session = session;
        this.cache = session.getCache();
        this.requestBody = ParamBean.getBody(requestBody);
    }

    public ParamBean(Map<String, String> requestParam, Map<String, Object> cache, String requestBody) {
        this(requestParam, cache, null, requestBody);
    }

    public ParamBean(Map<String, String> requestParam, AppSession session, String requestBody) {
        this(requestParam, null, session, requestBody);
    }

    private ParamBean(Map<String, String> requestParam, Map<String, Object> cache, AppSession session, String requestBody) {
        if (requestParam == null) {
            requestParam = new HashMap<String, String>();
        }
        if (cache == null) {
            cache = new HashMap<String, Object>();
        }
        if (session != null) {
            for (String key : session.getCache().keySet()) {
                cache.put(key, session.get(key));
            }
        }
        this.requestParam = requestParam;
        this.cache = cache;
        this.session = session;
        this.requestBody = ParamBean.getBody(requestBody);
    }

    private static JSON getBody(String requestBody) {
        Object body = new JSONObject();
        if (!StringUtil.isEmpty((CharSequence)requestBody)) {
            body = JSON.parse((String)requestBody);
        }
        return (JSON)body;
    }

    public AppSession getSession() {
        return this.session;
    }

    public Map<String, String> getRequestParam() {
        return this.requestParam;
    }

    public JSON getRequestBody() {
        return this.requestBody;
    }

    public Map<String, Object> getCache() {
        return this.cache;
    }
}

