package top.coos.app.handler;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;

import top.coos.app.Application;
import top.coos.app.bean.ParamBean;
import top.coos.app.context.AppContext;
import top.coos.app.entity.cache.CacheEntity;
import top.coos.app.session.AppSession;
import top.coos.util.ObjectUtil;
import top.coos.util.StringUtil;

public class CacheHandler {

	public static List<CacheEntity> getCaches(Application application) {

		AppContext context = application.getAppContext();
		if (context != null && context.getCaches() != null) {
			return context.getCaches();
		}
		return new ArrayList<CacheEntity>();
	}

	public static void cache(Application application, AppSession session) {

		List<CacheEntity> caches = getCaches(application);
		for (CacheEntity cache : caches) {
			cache(application, session, cache);
		}
	}

	public static void refreshLoginCache(Application application, AppSession session) {

		List<CacheEntity> caches = getCaches(application);
		for (CacheEntity cache : caches) {
			if (cache.isAfterlogin()) {
				session.removeCached(cache);
				cache(application, session, cache);
			}
		}
	}

	private static void cache(Application application, AppSession session, CacheEntity cache) {

		if (session == null) {
			return;
		}

		if (StringUtil.isEmpty(cache.getName())) {
			return;
		}
		if (session.isCached(cache)) {
			return;
		}
		if (!session.isLogin()) {
			if (cache.isAfterlogin()) {
				return;
			}
		}
		Object value = null;
		String serviceid = cache.getServiceid();
		if (!StringUtil.isEmpty(serviceid)) {
			ParamBean param = new ParamBean(null, session, null);
			try {
				value = ProcessorHandler.processService(application, serviceid, param);
				if (value != null) {
					JSONObject res = (JSONObject) JSONObject.toJSON(value);
					if (res.get("value") != null) {
						if (res.get("value") instanceof List) {
							value = res.getJSONArray("value");
						} else {
							value = res.getJSONObject("value");
						}
					}
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		session.set(cache.getName(), value);
		session.setCached(cache);
		if (value != null && value instanceof List) {
			refreshSelected(application, session, cache.getName(), null);
		}

	}

	public static void refreshSelected(Application application, AppSession session, String cachename, String selectedvalue) {

		if (application == null || session == null || StringUtil.isEmpty(cachename)) {
			return;
		}
		List<CacheEntity> caches = getCaches(application);
		CacheEntity cache = null;
		for (CacheEntity c : caches) {
			if (!StringUtil.isEmpty(c.getName()) && c.getName().equals(cachename)) {
				cache = c;
				break;
			}
		}

		if (cache != null && !StringUtil.isEmpty(cache.getSelectedcachename())) {
			Object cacheValue = session.get(cache.getName());
			String selectedcachename = cache.getSelectedcachename();
			String valuename = cache.getValuename();

			Object selectedValue = null;
			Object firstValue = null;
			if (cacheValue != null && !StringUtil.isEmpty(valuename) && cacheValue instanceof List) {
				JSONArray array = (JSONArray) JSONArray.toJSON(cacheValue);
				if (array.size() > 0) {
					firstValue = array.getJSONObject(0);
				}
				for (int i = 0; i < array.size(); i++) {
					JSONObject one = array.getJSONObject(i);
					Object value = one.get(valuename);
					if (ObjectUtil.equal(value, selectedvalue)) {
						selectedValue = one;
						break;
					}
				}
			}
			if (selectedValue == null) {
				selectedValue = firstValue;
			}
			if (selectedValue != null) {
				String json = JSONObject.toJSONString(selectedValue, SerializerFeature.DisableCircularReferenceDetect);

				selectedValue = JSONObject.parse(json);
			}
			session.set(selectedcachename, JSON.toJSON(selectedValue));

		}
	}
}
