/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.handler;

import java.util.ArrayList;
import java.util.Map;
import top.coos.app.Application;
import top.coos.app.entity.database.DatabaseTableColumnEntity;
import top.coos.app.entity.database.DatabaseTableEntity;
import top.coos.bean.Database;
import top.coos.cache.Cache;
import top.coos.cache.CacheUtil;
import top.coos.db.EntityUtil;
import top.coos.db.TableUtil;
import top.coos.db.meta.Column;
import top.coos.db.meta.Table;

public class TableHandler {
    static final Cache<DatabaseTableEntity, Table> TABLE_CACHE = CacheUtil.newCache();

    public static DatabaseTableEntity getTable(Class<?> clazz) {
        Table table = EntityUtil.getTable(clazz);
        return TableHandler.getTable(table);
    }

    public static DatabaseTableEntity getTable(Table table) {
        if (table == null) {
            return null;
        }
        DatabaseTableEntity tableEntity = new DatabaseTableEntity();
        tableEntity.setComment(table.getComment());
        tableEntity.setName(table.getName());
        tableEntity.setPartitiontablerule(table.getPartitiontablerule());
        ArrayList<DatabaseTableColumnEntity> columns = new ArrayList<DatabaseTableColumnEntity>();
        tableEntity.setColumns(columns);
        for (String key : table.keySet()) {
            DatabaseTableColumnEntity columnEntity = new DatabaseTableColumnEntity();
            Column column = (Column)table.get((Object)key);
            columnEntity.setName(column.getName());
            columnEntity.setComment(column.getComment());
            columnEntity.setDefaultvalue(column.getDefaultvalue());
            columnEntity.setLength(column.getLength());
            columnEntity.setNullable(column.isNullable());
            columnEntity.setPrecision(column.getPrecision());
            columnEntity.setPrimarykey(column.isPrimaryKey());
            if (column.isPrimaryKey()) {
                columnEntity.setNullable(false);
            }
            columnEntity.setScale(column.getScale());
            columnEntity.setSqltype(column.getType());
            columns.add(columnEntity);
        }
        return tableEntity;
    }

    public static String getRealtablename(DatabaseTableEntity databaseTable, Map<String, Object> data, Application application) throws Exception {
        if (databaseTable == null) {
            return null;
        }
        return TableHandler.getRealtablename(databaseTable, data, application.getDatabase(databaseTable.getDatabaseid()));
    }

    public static String getRealtablename(DatabaseTableEntity databaseTable, Map<String, Object> data, Database database) throws Exception {
        Table table = (Table)TABLE_CACHE.get((Object)databaseTable);
        if (table == null) {
            table = TableHandler.formatToTable(databaseTable);
            TABLE_CACHE.put((Object)databaseTable, (Object)table);
        }
        return TableUtil.getRealtablename((Table)table, data, (Database)database);
    }

    public static Table formatToTable(DatabaseTableEntity databaseTable) throws Exception {
        Table table = new Table(databaseTable.getName());
        table.setPartitiontablerule(databaseTable.getPartitiontablerule());
        table.setComment(databaseTable.getComment());
        if (databaseTable.getColumns() != null) {
            for (DatabaseTableColumnEntity tableColumn : databaseTable.getColumns()) {
                Column column = new Column();
                column.setName(tableColumn.getName());
                column.setType(tableColumn.getSqltype());
                column.setPrimaryKey(tableColumn.isPrimarykey());
                column.setComment(tableColumn.getComment());
                column.setLength(tableColumn.getLength());
                if (tableColumn.getLength() < 1) {
                    column.setLength(250);
                }
                column.setNullable(tableColumn.isNullable());
                column.setPrecision(tableColumn.getPrecision());
                column.setScale(tableColumn.getScale());
                if (tableColumn.isPrimarykey()) {
                    table.addPk(column.getName());
                    column.setNullable(false);
                }
                table.setColumn(column);
            }
        }
        return table;
    }
}

