/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.servlet;

import java.io.InputStream;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import top.coos.app.Application;
import top.coos.app.context.AppContext;
import top.coos.app.factory.ApplicationFactory;
import top.coos.util.FileUtil;
import top.coos.util.ResourceUtil;
import top.coos.util.StringUtil;

public class AppOutUtil {
    public static void outAppPage(HttpServletRequest request, HttpServletResponse response, String page) {
        if (!StringUtil.isEmpty((CharSequence)page)) {
            InputStream stream;
            URLClassLoader loader = null;
            if (!ApplicationFactory.isDev(request.getSession())) {
                try {
                    loader = ApplicationFactory.get(request).getClassLoader();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((stream = ResourceUtil.load(loader, (String)page)) != null) {
                StringBuffer body = new StringBuffer();
                body.append(FileUtil.read((InputStream)stream));
                AppOutUtil.outAppHTML(request, response, body);
            }
        }
    }

    public static void outAppPage(HttpServletRequest request, HttpServletResponse response, String page, Set<String> css, Set<String> jss) {
        if (!StringUtil.isEmpty((CharSequence)page)) {
            InputStream stream;
            URLClassLoader loader = null;
            if (!ApplicationFactory.isDev(request.getSession())) {
                try {
                    loader = ApplicationFactory.get(request).getClassLoader();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((stream = ResourceUtil.load(loader, (String)page)) != null) {
                StringBuffer body = new StringBuffer();
                body.append(FileUtil.read((InputStream)stream));
                AppOutUtil.outAppHTML(request, response, body, css, jss, null);
            }
        }
    }

    public static void outAppHTML(HttpServletRequest request, HttpServletResponse response, StringBuffer body) {
        AppOutUtil.outAppHTML(request, response, body, null, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void outAppHTML(HttpServletRequest request, HttpServletResponse response, StringBuffer body, Set<String> css, Set<String> jss, StringBuffer script) {
        if (css == null) {
            css = new HashSet<String>();
        }
        if (jss == null) {
            jss = new HashSet<String>();
        }
        try {
            Application application;
            AppContext context;
            if (!ApplicationFactory.isDev(request.getSession()) && (context = (application = ApplicationFactory.get(request)).getAppContext()) != null && context.getResources() == null) {
                // empty if block
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AppOutUtil.outHTML(request, response, body, css, jss, script);
    }

    private static void outHTML(HttpServletRequest request, HttpServletResponse response, StringBuffer body, Set<String> css, Set<String> jss, StringBuffer script) {
        String context = request.getServletContext().getContextPath();
        if (StringUtil.isEmpty((CharSequence)context)) {
            context = "/";
        }
        if (context.indexOf("/") != context.length() - 1) {
            context = context + "/";
        }
        StringBuffer html = new StringBuffer();
        html.append("<!DOCTYPE html>").append("\n");
        html.append("<html>").append("\n");
        html.append("<head lang=\"en\">").append("\n");
        html.append("<meta charset=\"UTF-8\" />").append("\n");
        html.append("<meta name=\"viewport\" content=\"width=device-width, initial-scale=1.0 , user-scalable=no\">");
        html.append("\n");
        html.append("<title>COOS</title>").append("\n");
        html.append("<link rel=\"shortcut icon\" type=\"image/x-icon\" href=\"" + context + "resources/coos/images/favicon.png\" media=\"screen\" />");
        html.append("\n");
        if (css != null) {
            for (String cs : css) {
                if (StringUtil.isEmpty((CharSequence)cs)) continue;
                html.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + context + cs + "\" />");
                html.append("\n");
            }
        }
        html.append("<script type=\"text/javascript\" src=\"" + context + "resources/coos/main.src.js\"></script>");
        html.append("\n");
        html.append("<script type=\"text/javascript\" src=\"" + context + "resources/app/main.js\"></script>");
        html.append("\n");
        if (jss != null) {
            for (String js : jss) {
                if (StringUtil.isEmpty((CharSequence)js)) continue;
                html.append("<script type=\"text/javascript\" src=\"" + context + js + "\"></script>");
                html.append("\n");
            }
        }
        if (!StringUtil.isEmpty((CharSequence)script)) {
            html.append("<script type=\"text/javascript\">");
            html.append("\n");
            html.append(script);
            html.append("\n");
            html.append("</script>");
            html.append("\n");
        }
        html.append("</head>").append("\n");
        html.append("<body>");
        if (body != null) {
            html.append(body);
        }
        html.append("</body>").append("\n");
        html.append("</html>").append("\n");
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/html");
        try {
            response.getWriter().write(html.toString());
            response.getWriter().flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

