package top.coos.app.bean.sql;

import java.util.List;
import java.util.Map;

import top.coos.app.entity.database.DatabaseTableEntity;
import top.coos.app.handler.TableHandler;
import top.coos.bean.Database;
import top.coos.util.IdGenerateUtil;
import top.coos.util.StringUtil;

public abstract class Abstract {

	protected abstract String first();

	protected abstract String splice();

	protected void appendEndSpace(StringBuffer sql) {

		int index = sql.lastIndexOf(" ");
		if (index < sql.length() - 1) {
			sql.append(" ");
		}
	}

	protected void appendList(List<?> list, StringBuffer sql, Map<String, Object> sqlParam, SqlBuilderParam builderParam)
			throws Exception {

		boolean first = true;
		if (list != null) {
			for (Object one : list) {
				if (one == null) {
					return;
				}
				if (one instanceof Abstract) {
					Abstract base = (Abstract) one;
					if (base instanceof Where) {
						Where where = (Where) one;
						validate(where, builderParam);
						String value = getValue(where, builderParam);
						if (StringUtil.isEmpty(value)) {
							continue;
						}
					}
					appendEndSpace(sql);
					if (first) {
						sql.append(base.first());
					} else {
						sql.append(base.splice());
					}
					appendEndSpace(sql);
					base.appendSql(sql, sqlParam, builderParam);
					appendEndSpace(sql);
					first = false;
				}

			}
		}
	}

	public abstract void appendSql(StringBuffer sql, Map<String, Object> sqlParam, SqlBuilderParam builderParam)
			throws Exception;

	/**
	 * 获取真实表名
	 * 
	 * @param table
	 * @return
	 */
	protected String getRealTableName(String name, SqlBuilderParam builderParam) {

		if (builderParam != null && builderParam.getApplication() != null) {
			DatabaseTableEntity table = builderParam.getApplication().getTableByName(name);
			if (table != null) {
				Database database = builderParam.getApplication().getDatabase(table.getDatabaseid());
				if (database != null) {
					try {
						String realtablename = TableHandler.getRealtablename(table, builderParam.getData(), database);
						return realtablename;
					} catch (Exception e) {
						e.printStackTrace();
					}
				}
			}
		}
		return name;
	}

	protected void validate(SqlField field, SqlBuilderParam builderParam) throws Exception {

		if (builderParam != null && builderParam.getHandler() != null) {
			builderParam.getHandler().validate(field, builderParam.getData());
		}
	}

	protected String getValue(SqlField field, SqlBuilderParam builderParam) throws Exception {

		String value = null;
		if (builderParam != null && builderParam.getHandler() != null) {
			value = builderParam.getHandler().getValue(field, builderParam.getData());
		}
		return value;
	}

	protected String getPlaceKey(SqlField field) {

		String key = field.getName();
		if (StringUtil.isEmpty(key)) {
			key = IdGenerateUtil.generateShort();
		}
		return key;
	}

}
