package top.coos.app.factory;

import top.coos.Configuration;
import top.coos.ConfigurationFactory;
import top.coos.app.Application;
import top.coos.app.source.Source;
import top.coos.cache.Cache;
import top.coos.cache.CacheUtil;
import top.coos.resource.handler.ResourceHandler;

public class ApplicationFactory {

	static final Cache<String, Application> CACHE_APPLICATION = CacheUtil.newTimedCache(0);

	static final String IS_DEV_SESSION_CACHE_NAME = "IS_DEV_SESSION_CACHE_NAME";

	static final String APPLICATION_SESSION_CACHE_NAME = "APPLICATION_SESSION_CACHE_NAME";

	static final String APPLICATION_CONTEXT_CACHE_NAME = "APPLICATION_CONTEXT_CACHE_NAME";

	static final Object LOCK = new Object();

	public static final void remove(String appid) {

		CACHE_APPLICATION.remove(appid);
	}

	public static final Application get(String appid) {

		return CACHE_APPLICATION.get(appid);
	}

	public static final Application create(Configuration configuration, Source source) throws Exception {

		String appid = configuration.getAppid();
		Application application = ResourceHandler.getBean(Application.class);
		application.init(configuration, source);
		CACHE_APPLICATION.put(appid, application);
		return application;
	}

	public static final Application getCache(Configuration configuration, Source source) throws Exception {

		String appid = configuration.getAppid();
		Application application = CACHE_APPLICATION.get(appid);
		if (application == null) {
			synchronized (LOCK) {
				application = CACHE_APPLICATION.get(appid);
				if (application == null) {
					application = create(configuration, source);
				}
			}
		}
		return application;
	}

	public static final Application get() throws Exception {

		return get(ConfigurationFactory.get());
	}

	public static final Application get(Source source) throws Exception {

		return get(ConfigurationFactory.get(), source);
	}

	public static final Application get(Configuration configuration) throws Exception {

		return get(configuration, null);
	}

	public static final Application get(Configuration configuration, Source source) throws Exception {

		return getCache(configuration, source);
	}

	public static final Application get(javax.servlet.http.HttpServletRequest request) throws Exception {

		return get(request.getSession());
	}

	public static final Application get(javax.servlet.http.HttpSession session) throws Exception {

		Application application = null;
		if (session != null) {
			if (session.getAttribute(APPLICATION_SESSION_CACHE_NAME) != null) {
				application = (Application) session.getAttribute(APPLICATION_SESSION_CACHE_NAME);
			}
			if (application == null) {
				application = get(session.getServletContext());
				session.setAttribute(APPLICATION_SESSION_CACHE_NAME, application);
			}
		} else {
			application = get();
		}

		return application;
	}

	public static final boolean isDev(javax.servlet.http.HttpSession session) {

		return session.getAttribute(IS_DEV_SESSION_CACHE_NAME) != null;
	}

	public static final void setDev(javax.servlet.http.HttpSession session) {

		session.setAttribute(IS_DEV_SESSION_CACHE_NAME, true);
	}

	public static final boolean has(javax.servlet.http.HttpSession session) {

		return session.getAttribute(APPLICATION_SESSION_CACHE_NAME) != null;
	}

	public static final void cacheToSession(javax.servlet.http.HttpSession session, Application application) {

		session.setAttribute(APPLICATION_SESSION_CACHE_NAME, application);
	}

	public static final Application get(javax.servlet.ServletContext context) throws Exception {

		Application application = null;
		if (context != null) {
			if (context.getAttribute(APPLICATION_CONTEXT_CACHE_NAME) != null) {
				application = (Application) context.getAttribute(APPLICATION_CONTEXT_CACHE_NAME);
			}
			if (application == null) {
				application = get();
				application.initContext();
				context.setAttribute(APPLICATION_CONTEXT_CACHE_NAME, application);
			}
		} else {
			application = get();
		}
		return application;
	}

}
