/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.bean.sql;

import java.util.List;
import java.util.Map;
import top.coos.app.bean.sql.SqlBuilderParam;
import top.coos.app.bean.sql.SqlField;
import top.coos.app.bean.sql.Where;
import top.coos.app.entity.database.DatabaseTableEntity;
import top.coos.app.handler.TableHandler;
import top.coos.bean.Database;
import top.coos.util.IdGenerateUtil;
import top.coos.util.StringUtil;

public abstract class Abstract {
    protected abstract String first();

    protected abstract String splice();

    protected void appendEndSpace(StringBuffer sql) {
        int index = sql.lastIndexOf(" ");
        if (index < sql.length() - 1) {
            sql.append(" ");
        }
    }

    protected void appendList(List<?> list, StringBuffer sql, Map<String, Object> sqlParam, SqlBuilderParam builderParam) throws Exception {
        boolean first = true;
        if (list != null) {
            for (Object one : list) {
                if (one == null) {
                    return;
                }
                if (!(one instanceof Abstract)) continue;
                Abstract base = (Abstract)one;
                if (base instanceof Where) {
                    Where where = (Where)one;
                    this.validate(where, builderParam);
                    String value = this.getValue(where, builderParam);
                    if (StringUtil.isEmpty((CharSequence)value)) continue;
                }
                this.appendEndSpace(sql);
                if (first) {
                    sql.append(base.first());
                } else {
                    sql.append(base.splice());
                }
                this.appendEndSpace(sql);
                base.appendSql(sql, sqlParam, builderParam);
                this.appendEndSpace(sql);
                first = false;
            }
        }
    }

    public abstract void appendSql(StringBuffer var1, Map<String, Object> var2, SqlBuilderParam var3) throws Exception;

    protected String getRealTableName(String name, SqlBuilderParam builderParam) {
        Database database;
        DatabaseTableEntity table;
        if (builderParam != null && builderParam.getApplication() != null && (table = builderParam.getApplication().getTableByName(name)) != null && (database = builderParam.getApplication().getDatabase(table.getDatabaseid())) != null) {
            try {
                String realtablename = TableHandler.getRealtablename(table, (Map<String, Object>)builderParam.getData(), database);
                return realtablename;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return name;
    }

    protected void validate(SqlField field, SqlBuilderParam builderParam) throws Exception {
        if (builderParam != null && builderParam.getHandler() != null) {
            builderParam.getHandler().validate(field, builderParam.getData());
        }
    }

    protected String getValue(SqlField field, SqlBuilderParam builderParam) throws Exception {
        String value = null;
        if (builderParam != null && builderParam.getHandler() != null) {
            value = builderParam.getHandler().getValue(field, builderParam.getData());
        }
        return value;
    }

    protected String getPlaceKey(SqlField field) {
        String key = field.getName();
        if (StringUtil.isEmpty((CharSequence)key)) {
            key = IdGenerateUtil.generateShort();
        }
        return key;
    }
}

