package top.coos.app;

import java.net.URLClassLoader;
import java.util.List;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;

import com.alibaba.fastjson.JSONObject;

import top.coos.Configuration;
import top.coos.app.bean.AppInfoBean;
import top.coos.app.bean.OptionBean;
import top.coos.app.bean.ProductInfoBean;
import top.coos.app.bean.service.ServiceBean;
import top.coos.app.context.AppContext;
import top.coos.app.entity.Entity;
import top.coos.app.entity.database.DatabaseTableColumnEntity;
import top.coos.app.entity.database.DatabaseTableEntity;
import top.coos.app.entity.dictionary.DictionaryEntity;
import top.coos.app.entity.page.PageEntity;
import top.coos.app.entity.resource.ResourceEntity;
import top.coos.app.entity.service.ServiceTemplateEntity;
import top.coos.app.event.AppEvent;
import top.coos.app.plugin.Plugin;
import top.coos.app.session.AppSession;
import top.coos.app.source.Source;
import top.coos.bean.Database;
import top.coos.service.Service;

public interface Application {

	public void init(Configuration configuration) throws Exception;

	public void init(Configuration configuration, Source source) throws Exception;

	public Object getCache(String key);

	public Application setCache(String key, Object value);

	public void reloadAppContext();

	public void initContext();

	public void refreshAppContext(AppContext appContext) throws Exception;

	public AppContext getAppContext();

	public URLClassLoader getClassLoader();

	public String getAppId();

	public String getProductId();

	public void triggerFilter(Filter filter, ServletRequest request, ServletResponse response, FilterChain chain)
			throws Exception;

	public void triggerControl(HttpServlet servlet, ServletRequest request, ServletResponse response) throws Exception;

	// public void triggerService(HttpServlet servlet, ServletRequest request,
	// ServletResponse response);

	// 触发实例化
	public void triggerNewSession(AppSession appSession);

	// 触发登录
	public void triggerLogin(AppSession appSession);

	// 触发登出
	public void triggerLogout(AppSession appSession);

	public boolean triggerEvent(AppEvent event, Object... objects);

	public AppInfoBean getApp();

	public ProductInfoBean getProduct();

	public DictionaryEntity getDictionary(String id);

	public DictionaryEntity getDictionaryByName(String name);

	public List<OptionBean> getOptions(String name);

	public List<OptionBean> getOptions(AppSession session, String name);

	public PageEntity getPage(String id);

	public ResourceEntity getResource(String id);

	public ServiceBean getService(String id);

	public ServiceBean getServiceByName(String name);

	public ServiceTemplateEntity getServiceTemplate(String id);

	public Database getDatabase(String id);

	public Database getDatabaseByName(String name);

	public DatabaseTableEntity getTable(String id);

	public DatabaseTableEntity getTableByName(String name);

	public DatabaseTableColumnEntity getColumn(String columnid);

	public void triggerChange(Entity entity);

	public void triggerDelete(Entity entity);

	public void triggerPluginsChange();

	public Object processService(String name, javax.servlet.http.HttpServletRequest request) throws Exception;

	public Service getService(Database database);

	public Service getService(DatabaseTableEntity table);

	public JSONObject getPluginSetting(String name, String version);

	public Plugin getPlugin(String name, String version);

	public JSONObject getPlugins();

}
