package top.coos.app.bean;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import top.coos.app.session.AppSession;
import top.coos.app.session.AppSessionHandler;
import top.coos.util.RequestUtil;
import top.coos.util.StringUtil;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

public class ParamBean {

	private final Map<String, String> requestParam;

	private final JSON requestBody;

	private final Map<String, Object> cache;

	private final AppSession session;

	public ParamBean(HttpServletRequest request) {

		Map<String, String> requestParam = RequestUtil.getRequestMap(request);
		String requestBody = RequestUtil.getStringContent(request);
		if (StringUtil.isEmpty(requestBody)) {
			if (requestParam != null && requestParam.size() > 0) {
				for (String key : requestParam.keySet()) {
					if (key.indexOf("{") == 0 || key.indexOf("[") == 0) {
						requestBody = key;
						requestParam.remove(key);
						break;
					}
				}
			}
		}
		AppSession session = AppSessionHandler.get(request);
		this.requestParam = requestParam;
		this.session = session;
		this.cache = session.getCache();
		this.requestBody = getBody(requestBody);
	}

	public ParamBean(Map<String, String> requestParam, Map<String, Object> cache, String requestBody) {

		this(requestParam, cache, null, requestBody);
	}

	public ParamBean(Map<String, String> requestParam, AppSession session, String requestBody) {

		this(requestParam, null, session, requestBody);
	}

	private ParamBean(Map<String, String> requestParam, Map<String, Object> cache, AppSession session, String requestBody) {

		if (requestParam == null) {
			requestParam = new HashMap<String, String>();
		}
		if (cache == null) {
			cache = new HashMap<String, Object>();
		}
		if (session != null) {
			for (String key : session.getCache().keySet()) {
				cache.put(key, session.get(key));
			}
		}
		this.requestParam = requestParam;
		this.cache = cache;
		this.session = session;
		this.requestBody = getBody(requestBody);
	}

	private static JSON getBody(String requestBody) {

		Object body = new JSONObject();
		if (!StringUtil.isEmpty(requestBody)) {
			body = JSON.parse(requestBody);
		}
		return (JSON) body;
	}

	public AppSession getSession() {

		return session;
	}

	public Map<String, String> getRequestParam() {

		return requestParam;
	}

	public JSON getRequestBody() {

		return requestBody;
	}

	public Map<String, Object> getCache() {

		return cache;
	}

}
