package top.coos.app.bean.sql;

import java.util.Map;

import top.coos.util.StringUtil;

public class From extends Abstract {

	private String table;

	private String alias;

	private Select select;

	public From() {

	}

	public From(String table, String alias) {

		this.table = table;
		this.alias = alias;
	}

	@Override
	protected String first() {

		return "FROM";
	}

	@Override
	protected String splice() {

		return ",";
	}

	public void appendSql(StringBuffer sql, Map<String, Object> sqlParam, SqlBuilderParam builderParam) throws Exception {

		table = StringUtil.trim(table);
		if (!StringUtil.isEmpty(table)) {
			String realTableName = getRealTableName(table, builderParam);
			sql.append(realTableName);
		}
		if (select != null) {
			select.appendSql(sql, sqlParam, builderParam);
		}
		alias = StringUtil.trim(alias);
		if (!StringUtil.isEmpty(alias)) {
			sql.append(" AS ");
			sql.append(alias);
		}

	}

	public String getTable() {

		return table;
	}

	public void setTable(String table) {

		this.table = table;
	}

	public String getAlias() {

		return alias;
	}

	public void setAlias(String alias) {

		this.alias = alias;
	}

	public Select getSelect() {

		return select;
	}

	public void setSelect(Select select) {

		this.select = select;
	}
}
