package top.coos.app.bean.sql;

import java.util.Map;

import top.coos.util.StringUtil;

public class LeftJoin extends Abstract {

	private String table;

	private String alias;

	private String on;

	public LeftJoin() {

	}

	public LeftJoin(String table, String alias, String on) {

		this.table = table;
		this.alias = alias;
		this.on = on;
	}

	@Override
	protected String first() {

		return "LEFT JOIN";
	}

	@Override
	protected String splice() {

		return "LEFT JOIN";
	}

	public void appendSql(StringBuffer sql, Map<String, Object> sqlParam, SqlBuilderParam builderParam) {

		table = StringUtil.trim(table);
		if (!StringUtil.isEmpty(table)) {
			String realTableName = getRealTableName(table, builderParam);
			sql.append(realTableName);
		}
		alias = StringUtil.trim(alias);
		if (!StringUtil.isEmpty(alias)) {
			sql.append(" AS ");
			sql.append(alias);
		}
		on = StringUtil.trim(on);
		if (!StringUtil.isEmpty(on)) {
			sql.append(" ON ");
			sql.append(on);
		}
	}

	public String getTable() {

		return table;
	}

	public void setTable(String table) {

		this.table = table;
	}

	public String getAlias() {

		return alias;
	}

	public void setAlias(String alias) {

		this.alias = alias;
	}

	public String getOn() {

		return on;
	}

	public void setOn(String on) {

		this.on = on;
	}

}
