package top.coos.app.bean.sql;

import java.util.Map;

import top.coos.util.StringUtil;

public class Order extends Abstract {

	private String tablealias;
	private String name;
	private String order;

	@Override
	protected String first() {

		return "ORDER BY";
	}

	@Override
	protected String splice() {

		return ",";
	}

	public void appendSql(StringBuffer sql, Map<String, Object> sqlParam, SqlBuilderParam builderParam) {

		name = StringUtil.trim(name);
		if (!StringUtil.isEmpty(name)) {
			tablealias = StringUtil.trim(tablealias);
			if (!StringUtil.isEmpty(tablealias)) {
				sql.append(tablealias).append(".");
			}
			sql.append(name);
		}
		order = StringUtil.trim(order);
		if (!StringUtil.isEmpty(order)) {
			sql.append(" ");
			sql.append(order);
		}
	}

	public String getTablealias() {

		return tablealias;
	}

	public void setTablealias(String tablealias) {

		this.tablealias = tablealias;
	}

	public String getName() {

		return name;
	}

	public void setName(String name) {

		this.name = name;
	}

	public String getOrder() {

		return order;
	}

	public void setOrder(String order) {

		this.order = order;
	}
}
