package top.coos.app.bean.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import top.coos.db.Page;

public class Select extends Abstract {

	private boolean distinct;

	private List<SelectColumn> columns = new ArrayList<SelectColumn>();

	private List<From> froms = new ArrayList<From>();

	private List<LeftJoin> leftjoins = new ArrayList<LeftJoin>();

	private List<Where> wheres = new ArrayList<Where>();

	private List<Group> groups = new ArrayList<Group>();

	private List<Having> havings = new ArrayList<Having>();

	private List<Order> orders = new ArrayList<Order>();

	private List<Union> unions = new ArrayList<Union>();

	private List<SubSelect> subselects = new ArrayList<SubSelect>();

	private int pageSize = 0;

	private int pageIndex = 0;

	private boolean forupdate;

	private boolean nowait;

	@Override
	protected String first() {

		// TODO Auto-generated method stub

		return "SELECT";
	}

	@Override
	protected String splice() {

		return "UNION";
	}

	public void appendSql(StringBuffer sql, Map<String, Object> sqlParam, SqlBuilderParam builderParam) throws Exception {

		sql.append("SELECT ");
		if (distinct) {
			sql.append("DISTINCT ");
		}
		if (columns == null || columns.size() == 0) {
			sql.append("* ");
		} else {
			appendList(columns, sql, sqlParam, builderParam);
		}

		append(sql, sqlParam, builderParam);

	}

	public void appendCountSql(StringBuffer sql, Map<String, Object> sqlParam, SqlBuilderParam builderParam)
			throws Exception {

		sql.append("SELECT COUNT(1) ");
		append(sql, sqlParam, builderParam);

	}

	public void append(StringBuffer sql, Map<String, Object> sqlParam, SqlBuilderParam builderParam) throws Exception {

		appendList(froms, sql, sqlParam, builderParam);
		appendList(leftjoins, sql, sqlParam, builderParam);
		appendList(wheres, sql, sqlParam, builderParam);
		appendList(groups, sql, sqlParam, builderParam);
		appendList(havings, sql, sqlParam, builderParam);
		appendList(orders, sql, sqlParam, builderParam);
		appendEndSpace(sql);
		if (forupdate) {
			sql.append("FOR UPDATE ");
			if (nowait) {
				sql.append("NOWAIT ");
			}
		}

		appendEndSpace(sql);
		if (pageSize > 0 && pageIndex > 0) {
			StringBuffer sqlBuffer = new StringBuffer(sql);
			Page page = new Page(pageIndex, pageSize);
			if (builderParam.getDialect() != null) {
				builderParam.getDialect().wrapPageSql(sqlBuffer, page);
			}
		}
		appendEndSpace(sql);
		appendList(unions, sql, sqlParam, builderParam);

	}

	public boolean isDistinct() {

		return distinct;
	}

	public void setDistinct(boolean distinct) {

		this.distinct = distinct;
	}

	public List<SelectColumn> getColumns() {

		return columns;
	}

	public Select addColumn(SelectColumn column) {

		if (column != null) {
			columns.add(column);
		}
		return this;
	}

	public void setColumns(List<SelectColumn> columns) {

		this.columns = columns;
	}

	public List<From> getFroms() {

		return froms;
	}

	public Select addFrom(From from) {

		if (from != null) {
			froms.add(from);
		}
		return this;
	}

	public void setFroms(List<From> froms) {

		this.froms = froms;
	}

	public List<LeftJoin> getLeftjoins() {

		return leftjoins;
	}

	public Select addLeftJoin(LeftJoin leftjoin) {

		if (leftjoin != null) {
			leftjoins.add(leftjoin);
		}
		return this;
	}

	public void setLeftjoins(List<LeftJoin> leftjoins) {

		this.leftjoins = leftjoins;
	}

	public List<Where> getWheres() {

		return wheres;
	}

	public Select addWhere(Where where) {

		if (where != null) {
			wheres.add(where);
		}
		return this;
	}

	public void setWheres(List<Where> wheres) {

		this.wheres = wheres;
	}

	public List<Group> getGroups() {

		return groups;
	}

	public Select addGroup(Group group) {

		if (group != null) {
			groups.add(group);
		}
		return this;
	}

	public void setGroups(List<Group> groups) {

		this.groups = groups;
	}

	public List<Having> getHavings() {

		return havings;
	}

	public Select addHaving(Having having) {

		if (having != null) {
			havings.add(having);
		}
		return this;
	}

	public void setHavings(List<Having> havings) {

		this.havings = havings;
	}

	public List<Order> getOrders() {

		return orders;
	}

	public Select addOrder(Order order) {

		if (order != null) {
			orders.add(order);
		}
		return this;
	}

	public void setOrders(List<Order> orders) {

		this.orders = orders;
	}

	public List<Union> getUnions() {

		return unions;
	}

	public Select addUnion(Union union) {

		if (union != null) {
			unions.add(union);
		}
		return this;
	}

	public void setUnions(List<Union> unions) {

		this.unions = unions;
	}

	public int getPageSize() {

		return pageSize;
	}

	public void setPageSize(int pageSize) {

		this.pageSize = pageSize;
	}

	public int getPageIndex() {

		return pageIndex;
	}

	public void setPageIndex(int pageIndex) {

		this.pageIndex = pageIndex;
	}

	public boolean isForupdate() {

		return forupdate;
	}

	public void setForupdate(boolean forupdate) {

		this.forupdate = forupdate;
	}

	public boolean isNowait() {

		return nowait;
	}

	public void setNowait(boolean nowait) {

		this.nowait = nowait;
	}

	public List<SubSelect> getSubselects() {

		return subselects;
	}

	public void setSubselects(List<SubSelect> subselects) {

		this.subselects = subselects;
	}

}
