package top.coos.app.bean.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import top.coos.util.StringUtil;

public class Update extends Abstract {

	private String table;

	private List<UpdateColumn> columns = new ArrayList<UpdateColumn>();

	private List<Where> wheres = new ArrayList<Where>();

	@Override
	protected String first() {

		return "UPDATE";
	}

	@Override
	protected String splice() {

		return "";
	}

	public void appendSql(StringBuffer sql, Map<String, Object> sqlParam, SqlBuilderParam builderParam) throws Exception {

		sql.append("UPDATE ");
		table = StringUtil.trim(table);
		if (!StringUtil.isEmpty(table)) {
			String realTableName = getRealTableName(table, builderParam);
			sql.append(realTableName);
		}
		appendEndSpace(sql);

		sql.append("SET ");
		int count = 0;
		if (columns != null) {
			for (UpdateColumn column : columns) {
				if (!validateIfrule(builderParam)) {
					continue;
				}
				String name = column.getName();
				name = StringUtil.trim(name);
				if (StringUtil.isEmpty(name)) {
					continue;
				}
				validate(column, builderParam);
				String value = getValue(column, builderParam);
				if (value == null) {
					continue;
				}
				count++;
				sql.append(name).append("=:").append(name).append(",");
				sqlParam.put(name, value);
			}

		}
		if (count == 0) {
			throw new Exception("未配置更新字段！");
		}
		sql.setLength(sql.length() - 1);

		appendList(wheres, sql, sqlParam, builderParam);
		appendEndSpace(sql);

	}

	public List<UpdateColumn> getColumns() {

		return columns;
	}

	public Update addColumn(UpdateColumn column) {

		if (column != null) {
			columns.add(column);
		}
		return this;
	}

	public void setColumns(List<UpdateColumn> columns) {

		this.columns = columns;
	}

	public List<Where> getWheres() {

		return wheres;
	}

	public Update addWhere(Where where) {

		if (where != null) {
			wheres.add(where);
		}
		return this;
	}

	public void setWheres(List<Where> wheres) {

		this.wheres = wheres;
	}

	public String getTable() {

		return table;
	}

	public void setTable(String table) {

		this.table = table;
	}

}
