package top.coos.app.enums;

import java.sql.Types;

public enum SqlType implements ValueAndText {

	VARCHAR("" + Types.VARCHAR, "VARCHAR"),

	INTEGER("" + Types.INTEGER, "INTEGER"),

	BOOLEAN("" + Types.BOOLEAN, "BOOLEAN"),

	BIGINT("" + Types.BIGINT, "BIGINT"),

	FLOAT("" + Types.FLOAT, "FLOAT"),

	DOUBLE("" + Types.DOUBLE, "DOUBLE"),

	DECIMAL("" + Types.DECIMAL, "DECIMAL"),

	DATE("" + Types.DATE, "DATE"),

	TIME("" + Types.TIME, "TIME"),

	BLOB("" + Types.BLOB, "BLOB");

	private SqlType(String value, String text) {

		this.value = value;
		this.text = text;
	}

	private final String value;

	private final String text;

	public String getValue() {

		return value;
	}

	public String getText() {

		return text;
	}
}
