package top.coos.app.handler;

import java.util.Set;

import com.alibaba.fastjson.JSONObject;

import top.coos.app.Application;
import top.coos.app.bean.ParamBean;
import top.coos.app.bean.service.ServiceBean;
import top.coos.app.ifaces.IField;
import top.coos.app.ifaces.IValueGet;
import top.coos.app.ifaces.param.ValueGetParam;
import top.coos.util.IdGenerateUtil;
import top.coos.util.MD5Util;
import top.coos.util.PasswordMD5Tool;
import top.coos.util.StringUtil;
import top.coos.value.ValueTool;

public class FieldHandler {

	final Application application;
	final ServiceBean service;
	final ParamBean param;

	public FieldHandler(Application application, ServiceBean service, ParamBean param) {

		this.application = application;
		this.service = service;
		this.param = param;
	}

	public void validate(IField field, JSONObject data) throws Exception {

		// if (!StringUtil.isEmpty(field.getvalidateclass())) {
		// FieldValidateHandler.validate(field.getFieldvalidateclass(), param);
		// return;
		// }
		String name = field.getName();
		String value = getValue(field, data);
		if (StringUtil.isEmpty(value)) {
			if (!field.isNullable()) {
				throw new Exception(name + "不能为空！");
			}

			//
		}

	}

	public String getValue(IField field, JSONObject data) throws Exception {

		String value = null;
		if (!StringUtil.isEmpty(field.getValuegetclass())) {

			value = processValueGet(field, data);
		} else {

			String name = field.getName();
			value = getRequestValue(name, data);
			if (!StringUtil.isEmpty(field.getValue())) {
				value = ValueTool.getValue(field.getValue(), data, param.getRequestParam(), param.getCache());
			}
			if (StringUtil.isEmpty(value)) {
				if (!StringUtil.isEmpty(field.getDefaultvalue())) {
					value = ValueTool.getValue(field.getDefaultvalue(), data, param.getRequestParam(), param.getCache());
				} else {
				}

			}
		}
		value = ValueTool.getValue(value, data, param.getRequestParam(), param.getCache());
		if (field.isValueusegenerate() || (field.isNovalueusegenerate() && StringUtil.isEmpty(value))) {
			value = IdGenerateUtil.generate();
		}
		if ((!StringUtil.isEmpty(value))) {
			if (field.isForpassword()) {
				value = PasswordMD5Tool.getMD5Password(value);
			} else if (field.isUsemd5()) {
				value = MD5Util.MD5(value);
			}

		}
		return value;
	}

	public String getRequestValue(String name, JSONObject data) throws Exception {

		return ValueTool.getRequestValue(data, name);

	}

	public String processValueGet(IField field, JSONObject data) throws Exception {

		Set<Class<?>> clazzs = ClassHandler.getClass(field.getValuegetclass());

		for (Class<?> clazz : clazzs) {
			Object object = clazz.newInstance();
			if (object instanceof IValueGet) {
				IValueGet get = (IValueGet) object;
				return get.get(new ValueGetParam(service, field, param, data));
			} else {
				throw new Exception(clazz + " not extends " + IValueGet.class.getName());
			}
		}

		return null;
	}
}
