package top.coos.app.ifaces;

import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import java.util.Map;

import top.coos.db.ds.DSFactory;

public interface IDao {

	public void init(DSFactory factory);

	public DSFactory getFactory();

	public Connection getConnection() throws Exception;

	public List<Map<String, Object>> queryList(String sql, Map<String, Object> param) throws Exception;

	public Map<String, Object> queryOne(String sql, Map<String, Object> param) throws Exception;

	public int delete(String tablename, String key, Serializable id) throws Exception;

	public int executeSql(String sql, Map<String, Object> param) throws Exception;

	public int executeSql(List<String> sqls, List<Map<String, Object>> params) throws Exception;

	public int queryCount(String sql, Map<String, Object> param) throws Exception;

	public List<Map<String, Object>> queryPage(String sql, Map<String, Object> param, int pageSize, int currentPage)
			throws Exception;

}
