/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.bean.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import top.coos.app.bean.sql.Abstract;
import top.coos.app.bean.sql.From;
import top.coos.app.bean.sql.Group;
import top.coos.app.bean.sql.Having;
import top.coos.app.bean.sql.LeftJoin;
import top.coos.app.bean.sql.Order;
import top.coos.app.bean.sql.SelectColumn;
import top.coos.app.bean.sql.SqlBuilderParam;
import top.coos.app.bean.sql.SubSelect;
import top.coos.app.bean.sql.Union;
import top.coos.app.bean.sql.Where;
import top.coos.db.Page;

public class Select
extends Abstract {
    private boolean distinct;
    private List<SelectColumn> columns = new ArrayList<SelectColumn>();
    private List<From> froms = new ArrayList<From>();
    private List<LeftJoin> leftjoins = new ArrayList<LeftJoin>();
    private List<Where> wheres = new ArrayList<Where>();
    private List<Group> groups = new ArrayList<Group>();
    private List<Having> havings = new ArrayList<Having>();
    private List<Order> orders = new ArrayList<Order>();
    private List<Union> unions = new ArrayList<Union>();
    private List<SubSelect> subselects = new ArrayList<SubSelect>();
    private int pageSize = 0;
    private int pageIndex = 0;
    private boolean forupdate;
    private boolean nowait;

    @Override
    protected String first() {
        return "SELECT";
    }

    @Override
    protected String splice() {
        return "UNION";
    }

    @Override
    public void appendSql(StringBuffer sql, Map<String, Object> sqlParam, SqlBuilderParam builderParam) throws Exception {
        sql.append("SELECT ");
        if (this.distinct) {
            sql.append("DISTINCT ");
        }
        if (this.columns == null || this.columns.size() == 0) {
            sql.append("* ");
        } else {
            this.appendList(this.columns, sql, sqlParam, builderParam);
        }
        this.append(sql, sqlParam, builderParam);
    }

    public void appendCountSql(StringBuffer sql, Map<String, Object> sqlParam, SqlBuilderParam builderParam) throws Exception {
        sql.append("SELECT COUNT(1) ");
        this.append(sql, sqlParam, builderParam);
    }

    public void append(StringBuffer sql, Map<String, Object> sqlParam, SqlBuilderParam builderParam) throws Exception {
        this.appendList(this.froms, sql, sqlParam, builderParam);
        this.appendList(this.leftjoins, sql, sqlParam, builderParam);
        this.appendList(this.wheres, sql, sqlParam, builderParam);
        this.appendList(this.groups, sql, sqlParam, builderParam);
        this.appendList(this.havings, sql, sqlParam, builderParam);
        this.appendList(this.orders, sql, sqlParam, builderParam);
        this.appendEndSpace(sql);
        if (this.forupdate) {
            sql.append("FOR UPDATE ");
            if (this.nowait) {
                sql.append("NOWAIT ");
            }
        }
        this.appendEndSpace(sql);
        if (this.pageSize > 0 && this.pageIndex > 0) {
            StringBuffer sqlBuffer = new StringBuffer(sql);
            Page page = new Page(this.pageIndex, this.pageSize);
            if (builderParam.getDialect() != null) {
                builderParam.getDialect().wrapPageSql(sqlBuffer, page);
            }
        }
        this.appendEndSpace(sql);
        this.appendList(this.unions, sql, sqlParam, builderParam);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public List<SelectColumn> getColumns() {
        return this.columns;
    }

    public Select addColumn(SelectColumn column) {
        if (column != null) {
            this.columns.add(column);
        }
        return this;
    }

    public void setColumns(List<SelectColumn> columns) {
        this.columns = columns;
    }

    public List<From> getFroms() {
        return this.froms;
    }

    public Select addFrom(From from) {
        if (from != null) {
            this.froms.add(from);
        }
        return this;
    }

    public void setFroms(List<From> froms) {
        this.froms = froms;
    }

    public List<LeftJoin> getLeftjoins() {
        return this.leftjoins;
    }

    public Select addLeftJoin(LeftJoin leftjoin) {
        if (leftjoin != null) {
            this.leftjoins.add(leftjoin);
        }
        return this;
    }

    public void setLeftjoins(List<LeftJoin> leftjoins) {
        this.leftjoins = leftjoins;
    }

    public List<Where> getWheres() {
        return this.wheres;
    }

    public Select addWhere(Where where) {
        if (where != null) {
            this.wheres.add(where);
        }
        return this;
    }

    public void setWheres(List<Where> wheres) {
        this.wheres = wheres;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public Select addGroup(Group group) {
        if (group != null) {
            this.groups.add(group);
        }
        return this;
    }

    public void setGroups(List<Group> groups) {
        this.groups = groups;
    }

    public List<Having> getHavings() {
        return this.havings;
    }

    public Select addHaving(Having having) {
        if (having != null) {
            this.havings.add(having);
        }
        return this;
    }

    public void setHavings(List<Having> havings) {
        this.havings = havings;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public Select addOrder(Order order) {
        if (order != null) {
            this.orders.add(order);
        }
        return this;
    }

    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public List<Union> getUnions() {
        return this.unions;
    }

    public Select addUnion(Union union) {
        if (union != null) {
            this.unions.add(union);
        }
        return this;
    }

    public void setUnions(List<Union> unions) {
        this.unions = unions;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    public boolean isForupdate() {
        return this.forupdate;
    }

    public void setForupdate(boolean forupdate) {
        this.forupdate = forupdate;
    }

    public boolean isNowait() {
        return this.nowait;
    }

    public void setNowait(boolean nowait) {
        this.nowait = nowait;
    }

    public List<SubSelect> getSubselects() {
        return this.subselects;
    }

    public void setSubselects(List<SubSelect> subselects) {
        this.subselects = subselects;
    }
}

