package top.coos.app.bean.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import top.coos.util.StringUtil;

public class Insert extends Abstract {

	private List<InsertColumn> columns = new ArrayList<InsertColumn>();

	private String table;

	@Override
	protected String first() {

		return "INSERT INTO";
	}

	@Override
	protected String splice() {

		return "";
	}

	public void appendSql(StringBuffer sql, Map<String, Object> sqlParam, SqlBuilderParam builderParam) throws Exception {

		sql.append("INSERT INTO ");
		table = StringUtil.trim(table);
		if (!StringUtil.isEmpty(table)) {
			String realTableName = getRealTableName(table, builderParam);
			sql.append(realTableName);
		}
		appendEndSpace(sql);
		StringBuffer column_sql = new StringBuffer();
		StringBuffer value_sql = new StringBuffer();
		int count = 0;
		if (columns != null) {
			for (InsertColumn column : columns) {
				if (!validateIfrule(builderParam)) {
					continue;
				}
				String name = column.getName();
				name = StringUtil.trim(name);
				if (StringUtil.isEmpty(name)) {
					continue;
				}
				validate(column, builderParam);
				String value = getValue(column, builderParam);
				if (value == null) {
					continue;
				}
				count++;
				column_sql.append(name + ",");
				value_sql.append(":" + name + ",");
				sqlParam.put(name, value);
			}

		}
		if (count == 0) {
			throw new Exception("未配置插入字段！");
		}
		column_sql.setLength(column_sql.length() - 1);
		value_sql.setLength(value_sql.length() - 1);
		sql.append(" (");
		sql.append(column_sql);
		sql.append(") VALUES (");
		sql.append(value_sql);
		sql.append(") ");

		appendEndSpace(sql);

	}

	public List<InsertColumn> getColumns() {

		return columns;
	}

	public Insert addColumn(InsertColumn column) {

		if (column != null) {
			columns.add(column);
		}
		return this;
	}

	public void setColumns(List<InsertColumn> columns) {

		this.columns = columns;
	}

	public String getTable() {

		return table;
	}

	public void setTable(String table) {

		this.table = table;
	}
}
