package top.coos.app.bean.sql;

import java.util.Map;

import top.coos.util.StringUtil;

public class SelectColumn extends Abstract {

	private String tablealias;

	private String name;

	private String alias;

	private Select select;

	public SelectColumn() {

	}

	public SelectColumn(String name, String alias) {

		this(null, name, alias);
	}

	public SelectColumn(String tablealias, String name, String alias) {

		this.tablealias = tablealias;
		this.name = name;
		this.alias = alias;
	}

	@Override
	protected String first() {

		return "";
	}

	@Override
	protected String splice() {

		return ",";
	}

	public void appendSql(StringBuffer sql, Map<String, Object> sqlParam, SqlBuilderParam builderParam) throws Exception {

		name = StringUtil.trim(name);
		if (!StringUtil.isEmpty(name)) {
			tablealias = StringUtil.trim(tablealias);
			if (!StringUtil.isEmpty(tablealias)) {
				sql.append(tablealias).append(".");
			}
			sql.append(name);
		}
		if (select != null) {
			select.appendSql(sql, sqlParam, builderParam);
		}
		alias = StringUtil.trim(alias);
		if (!StringUtil.isEmpty(alias)) {
			sql.append(" AS ");
			sql.append(alias);
		}

	}

	public String getName() {

		return name;
	}

	public SelectColumn setName(String name) {

		this.name = name;
		return this;
	}

	public String getAlias() {

		return alias;
	}

	public SelectColumn setAlias(String alias) {

		this.alias = alias;
		return this;
	}

	public Select getSelect() {

		return select;
	}

	public SelectColumn setSelect(Select select) {

		this.select = select;
		return this;
	}

	public String getTablealias() {

		return tablealias;
	}

	public void setTablealias(String tablealias) {

		this.tablealias = tablealias;
	}

}
