package top.coos.app.bean.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

import top.coos.app.enums.ComparisonOperator;
import top.coos.util.StringUtil;

public class Where extends SqlField {

	private String tablealias;

	private String comparisonoperator;

	private String relationaloperation;

	private List<Where> wheres = new ArrayList<Where>();

	public Where() {

	}

	public Where(String name) {

		this(null, name);
	}

	public Where(String tablealias, String name) {

		this.tablealias = tablealias;
		this.name = name;
	}

	@Override
	protected String first() {

		return "WHERE";
	}

	@Override
	protected String splice() {

		if (!StringUtil.isEmpty(relationaloperation)) {
			return relationaloperation;
		}
		return "AND";
	}

	public void appendSql(StringBuffer sql, Map<String, Object> sqlParam, SqlBuilderParam builderParam) throws Exception {

		String value = getValue(this, builderParam);
		if (StringUtil.isEmpty(value)) {
			return;
		}
		String whereName = "";
		name = StringUtil.trim(name);
		if (!StringUtil.isEmpty(name)) {
			tablealias = StringUtil.trim(tablealias);
			if (!StringUtil.isEmpty(tablealias)) {
				whereName += tablealias + ".";
			}
			whereName += name;
		}

		this.comparisonoperator = StringUtil.trim(this.comparisonoperator);
		ComparisonOperator comparisonoperator = ComparisonOperator.get(this.comparisonoperator);

		if (comparisonoperator.equals(ComparisonOperator.IN_LIKE)) {

		} else {
			sql.append(whereName);
		}

		String placeKey = getPlaceKey(this);
		placeKey = StringUtil.trim(placeKey);

		switch (comparisonoperator) {
		case LIKE:
			sql.append(" LIKE :").append(placeKey);
			sqlParam.put(placeKey, "%" + value + "%");
			break;
		case LIKE_BEFORE:
			sql.append(" LIKE :").append(placeKey);
			sqlParam.put(placeKey, "%" + value);
			break;
		case LIKE_AFTER:
			sql.append(" LIKE :").append(placeKey);
			sqlParam.put(placeKey, value + "%");

			break;
		case IN:
			List<String> values = getValues(value);
			StringBuffer inValue = new StringBuffer("(");
			for (String v : values) {
				v = StringUtil.trim(v);
				if (StringUtil.isEmpty(v)) {
					continue;
				}
				inValue.append("'");
				inValue.append(v);
				inValue.append("'");
				inValue.append(",");
			}
			if (inValue.length() > 1) {
				inValue.setLength(inValue.length() - 1);
			}
			inValue.append(")");

			sql.append(" IN ").append(inValue.toString());

			break;
		case NOT_IN:
			values = getValues(value);
			inValue = new StringBuffer("(");
			for (String v : values) {
				v = StringUtil.trim(v);
				if (StringUtil.isEmpty(v)) {
					continue;
				}
				inValue.append("'");
				inValue.append(v);
				inValue.append("'");
				inValue.append(",");
			}
			if (inValue.length() > 1) {
				inValue.setLength(inValue.length() - 1);
			}
			inValue.append(")");

			sql.append(" NOT IN ").append(inValue.toString());

			break;
		case IN_LIKE:
			values = getValues(value);
			boolean isFirst = true;
			sql.append(" ( 1=2 ");
			for (int i = 0; i < values.size(); i++) {
				String v = values.get(i);
				v = StringUtil.trim(v);
				if (StringUtil.isEmpty(v)) {
					continue;
				}
				if (!isFirst) {

				}
				sql.append(" OR ").append(whereName);
				sql.append(" LIKE ").append("%" + v + "%");

				isFirst = false;
			}
			sql.append(") ");

			break;
		default:
			sql.append(comparisonoperator.getValue()).append(" :").append(placeKey);
			sqlParam.put(placeKey, value);
			break;
		}

	}

	private List<String> getValues(String value) {

		List<String> values = new ArrayList<String>();
		if (value != null) {
			if (value.indexOf("[") == 0 && value.indexOf("]") == value.length() - 1) {
				JSONArray array = JSONArray.parseArray(value);
				for (int i = 0; i < array.size(); i++) {
					Object one = array.get(i);
					if (one != null) {
						if (one instanceof JSONArray) {

						} else if (one instanceof JSONObject) {

						} else {
							values.add(one.toString());
						}
					}
				}
				return values;
			}
			if (value.indexOf("(") == 0 && value.lastIndexOf(")") == value.length() - 1) {
				value = value.substring(value.indexOf("("), value.lastIndexOf(")") - 1);
			}
			String delimiter = ",";
			if (value.indexOf(delimiter) >= 0) {
				String[] vs = value.split(delimiter);
				for (String v : vs) {
					v = StringUtil.trim(v);
					if (!StringUtil.isEmpty(v)) {
						values.add(v);
					}
				}
			} else {
				values.add(value);
			}
		}

		return values;
	}

	public String getRelationaloperation() {

		return relationaloperation;
	}

	public void setRelationaloperation(String relationaloperation) {

		this.relationaloperation = relationaloperation;
	}

	public String getTablealias() {

		return tablealias;
	}

	public void setTablealias(String tablealias) {

		this.tablealias = tablealias;
	}

	public String getName() {

		return name;
	}

	public void setName(String name) {

		this.name = name;
	}

	public String getValue() {

		return value;
	}

	public void setValue(String value) {

		this.value = value;
	}

	public String getComparisonoperator() {

		return comparisonoperator;
	}

	public void setComparisonoperator(String comparisonoperator) {

		this.comparisonoperator = comparisonoperator;
	}

	public List<Where> getWheres() {

		return wheres;
	}

	public Where addWhere(Where where) {

		if (where != null) {
			wheres.add(where);
		}
		return this;
	}

	public void setWheres(List<Where> wheres) {

		this.wheres = wheres;
	}
}
