/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.bean.sql;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import top.coos.app.bean.sql.SqlBuilderParam;
import top.coos.app.bean.sql.SqlField;
import top.coos.app.enums.ComparisonOperator;
import top.coos.util.StringUtil;

public class Where
extends SqlField {
    private String tablealias;
    private String comparisonoperator;
    private String relationaloperation;
    private List<Where> wheres = new ArrayList<Where>();

    public Where() {
    }

    public Where(String name) {
        this(null, name);
    }

    public Where(String tablealias, String name) {
        this.tablealias = tablealias;
        this.name = name;
    }

    @Override
    protected String first() {
        return "WHERE";
    }

    @Override
    protected String splice() {
        if (!StringUtil.isEmpty((CharSequence)this.relationaloperation)) {
            return this.relationaloperation;
        }
        return "AND";
    }

    @Override
    public void appendSql(StringBuffer sql, Map<String, Object> sqlParam, SqlBuilderParam builderParam) throws Exception {
        String value = this.getValue(this, builderParam);
        if (StringUtil.isEmpty((CharSequence)value)) {
            return;
        }
        String whereName = "";
        this.name = StringUtil.trim((CharSequence)this.name);
        if (!StringUtil.isEmpty((CharSequence)this.name)) {
            this.tablealias = StringUtil.trim((CharSequence)this.tablealias);
            if (!StringUtil.isEmpty((CharSequence)this.tablealias)) {
                whereName = whereName + this.tablealias + ".";
            }
            whereName = whereName + this.name;
        }
        this.comparisonoperator = StringUtil.trim((CharSequence)this.comparisonoperator);
        ComparisonOperator comparisonoperator = ComparisonOperator.get(this.comparisonoperator);
        if (!comparisonoperator.equals((Object)ComparisonOperator.IN_LIKE)) {
            sql.append(whereName);
        }
        String placeKey = this.getPlaceKey(this);
        placeKey = StringUtil.trim((CharSequence)placeKey);
        switch (comparisonoperator) {
            case LIKE: {
                sql.append(" LIKE :").append(placeKey);
                sqlParam.put(placeKey, "%" + value + "%");
                break;
            }
            case LIKE_BEFORE: {
                sql.append(" LIKE :").append(placeKey);
                sqlParam.put(placeKey, "%" + value);
                break;
            }
            case LIKE_AFTER: {
                sql.append(" LIKE :").append(placeKey);
                sqlParam.put(placeKey, value + "%");
                break;
            }
            case IN: {
                List<String> values = this.getValues(value);
                StringBuffer inValue = new StringBuffer("(");
                for (String v : values) {
                    if (StringUtil.isEmpty((CharSequence)(v = StringUtil.trim((CharSequence)v)))) continue;
                    inValue.append("'");
                    inValue.append(v);
                    inValue.append("'");
                    inValue.append(",");
                }
                if (inValue.length() > 1) {
                    inValue.setLength(inValue.length() - 1);
                }
                inValue.append(")");
                sql.append(" IN ").append(inValue.toString());
                break;
            }
            case NOT_IN: {
                List<String> values = this.getValues(value);
                StringBuffer inValue = new StringBuffer("(");
                for (String v : values) {
                    if (StringUtil.isEmpty((CharSequence)(v = StringUtil.trim((CharSequence)v)))) continue;
                    inValue.append("'");
                    inValue.append(v);
                    inValue.append("'");
                    inValue.append(",");
                }
                if (inValue.length() > 1) {
                    inValue.setLength(inValue.length() - 1);
                }
                inValue.append(")");
                sql.append(" NOT IN ").append(inValue.toString());
                break;
            }
            case IN_LIKE: {
                List<String> values = this.getValues(value);
                boolean isFirst = true;
                sql.append(" ( 1=2 ");
                for (int i = 0; i < values.size(); ++i) {
                    String v = values.get(i);
                    if (StringUtil.isEmpty((CharSequence)(v = StringUtil.trim((CharSequence)v)))) continue;
                    if (!isFirst) {
                        // empty if block
                    }
                    sql.append(" OR ").append(whereName);
                    sql.append(" LIKE ").append("%" + v + "%");
                    isFirst = false;
                }
                sql.append(") ");
                break;
            }
            default: {
                sql.append(comparisonoperator.getValue()).append(" :").append(placeKey);
                sqlParam.put(placeKey, value);
            }
        }
    }

    private List<String> getValues(String value) {
        ArrayList<String> values = new ArrayList<String>();
        if (value != null) {
            String delimiter;
            if (value.indexOf("[") == 0 && value.indexOf("]") == value.length() - 1) {
                JSONArray array = JSONArray.parseArray((String)value);
                for (int i = 0; i < array.size(); ++i) {
                    Object one = array.get(i);
                    if (one == null || one instanceof JSONArray || one instanceof JSONObject) continue;
                    values.add(one.toString());
                }
                return values;
            }
            if (value.indexOf("(") == 0 && value.lastIndexOf(")") == value.length() - 1) {
                value = value.substring(value.indexOf("("), value.lastIndexOf(")") - 1);
            }
            if (value.indexOf(delimiter = ",") >= 0) {
                String[] vs;
                for (String v : vs = value.split(delimiter)) {
                    if (StringUtil.isEmpty((CharSequence)(v = StringUtil.trim((CharSequence)v)))) continue;
                    values.add(v);
                }
            } else {
                values.add(value);
            }
        }
        return values;
    }

    public String getRelationaloperation() {
        return this.relationaloperation;
    }

    public void setRelationaloperation(String relationaloperation) {
        this.relationaloperation = relationaloperation;
    }

    public String getTablealias() {
        return this.tablealias;
    }

    public void setTablealias(String tablealias) {
        this.tablealias = tablealias;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    public String getComparisonoperator() {
        return this.comparisonoperator;
    }

    public void setComparisonoperator(String comparisonoperator) {
        this.comparisonoperator = comparisonoperator;
    }

    public List<Where> getWheres() {
        return this.wheres;
    }

    public Where addWhere(Where where) {
        if (where != null) {
            this.wheres.add(where);
        }
        return this;
    }

    public void setWheres(List<Where> wheres) {
        this.wheres = wheres;
    }
}

