/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.enums;

import top.coos.util.StringUtil;

public enum ComparisonOperator {
    EQ("=", "\u7b49\u4e8e"),
    NEQ("<>", "\u4e0d\u7b49\u4e8e"),
    GT(">", "\u5927\u4e8e"),
    LT("<", "\u5c0f\u4e8e"),
    GTE(">=", "\u5927\u4e8e\u7b49\u4e8e"),
    LTE("<=", "\u5c0f\u4e8e\u7b49\u4e8e"),
    LIKE("LIKE", "LIKE %...%"),
    LIKE_AFTER("LIKE%", "LIKE ...%"),
    LIKE_BEFORE("%LIKE", "LIKE %..."),
    IN("IN", "IN"),
    IN_LIKE("IN LIKE", "IN LIKE %...%"),
    NOT_IN("NOT IN", "NOT IN");

    private String value;
    private String text;

    public static ComparisonOperator get(String value) {
        if (StringUtil.isEmpty((CharSequence)value)) {
            return EQ;
        }
        ComparisonOperator comparisonOperator = null;
        for (ComparisonOperator one : ComparisonOperator.values()) {
            if (!one.getValue().equalsIgnoreCase(value) && !one.toString().equalsIgnoreCase(value)) continue;
            comparisonOperator = one;
            break;
        }
        if (comparisonOperator == null) {
            return EQ;
        }
        return comparisonOperator;
    }

    private ComparisonOperator(String value, String text) {
        this.value = value;
        this.text = text;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }
}

