/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import top.coos.app.Application;
import top.coos.app.factory.ApplicationFactory;
import top.coos.app.servlet.AppServletContext;
import top.coos.app.session.AppSession;
import top.coos.app.session.AppSessionHandler;
import top.coos.factory.LogFactory;
import top.coos.util.RequestUtil;

@WebFilter(urlPatterns={"/*"})
public class AppFilter
implements Filter {
    Logger log = LogFactory.get();

    public void destroy() {
    }

    public boolean except(ServletRequest request, ServletResponse response) {
        String servletpath = RequestUtil.getServletpath((HttpServletRequest)((HttpServletRequest)request));
        return servletpath.startsWith("/resources/") || servletpath.startsWith("/error/") || servletpath.startsWith("/coos/data") || servletpath.startsWith("/coos/app") || servletpath.startsWith("/coos/error") || servletpath.startsWith("/coos/file");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            if (this.except(request, response)) {
                chain.doFilter(request, response);
            } else if (!ApplicationFactory.isDev(((HttpServletRequest)request).getSession())) {
                Application application = ApplicationFactory.get((HttpServletRequest)request);
                AppSession appSession = AppSessionHandler.get((HttpServletRequest)request);
                if (appSession.isLogin()) {
                    // empty if block
                }
                application.triggerFilter(this, request, response, chain);
            } else {
                chain.doFilter(request, response);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init(FilterConfig config) throws ServletException {
        AppServletContext.initialize(config.getServletContext());
    }
}

