/*
 * Decompiled with CFR 0.152.
 */
package top.coos.app.handler;

import com.alibaba.fastjson.JSONObject;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import top.coos.app.Application;
import top.coos.app.bean.ParamBean;
import top.coos.app.bean.service.ServiceBean;
import top.coos.app.handler.ClassHandler;
import top.coos.app.ifaces.IField;
import top.coos.app.ifaces.IValueGet;
import top.coos.app.ifaces.param.ValueGetParam;
import top.coos.util.IdGenerateUtil;
import top.coos.util.MD5Util;
import top.coos.util.PasswordMD5Tool;
import top.coos.util.StringUtil;
import top.coos.value.ValueTool;

public class FieldHandler {
    final Application application;
    final ServiceBean service;
    final ParamBean param;

    public FieldHandler(Application application, ServiceBean service, ParamBean param) {
        this.application = application;
        this.service = service;
        this.param = param;
    }

    public void validate(IField field, JSONObject data) throws Exception {
        String name = field.getName();
        String value = this.getValue(field, data);
        if (StringUtil.isEmpty((CharSequence)value) && !field.isNullable()) {
            throw new Exception(name + "\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    public String getValue(IField field, JSONObject data) throws Exception {
        String value = null;
        if (!StringUtil.isEmpty((CharSequence)field.getValuegetclass())) {
            value = this.processValueGet(field, data);
        } else {
            String name = field.getName();
            value = this.getRequestValue(name, data);
            if (!StringUtil.isEmpty((CharSequence)field.getValue())) {
                value = ValueTool.getValue((String)field.getValue(), (JSONObject)data, this.param.getRequestParam(), this.param.getCache());
            }
            if (StringUtil.isEmpty((CharSequence)value) && !StringUtil.isEmpty((CharSequence)field.getDefaultvalue())) {
                value = ValueTool.getValue((String)field.getDefaultvalue(), (JSONObject)data, this.param.getRequestParam(), this.param.getCache());
            }
        }
        value = ValueTool.getValue((String)value, (JSONObject)data, this.param.getRequestParam(), this.param.getCache());
        if (field.isValueusegenerate() || field.isNovalueusegenerate() && StringUtil.isEmpty((CharSequence)value)) {
            value = IdGenerateUtil.generate();
        }
        if (!StringUtil.isEmpty((CharSequence)value)) {
            if (field.isForpassword()) {
                value = PasswordMD5Tool.getMD5Password((String)value);
            } else if (field.isUsemd5()) {
                value = MD5Util.MD5((String)value);
            }
        }
        return value;
    }

    public String getRequestValue(String name, JSONObject data) throws Exception {
        return ValueTool.getRequestValue((Map)data, (String)name);
    }

    public String processValueGet(IField field, JSONObject data) throws Exception {
        Set<Class<?>> clazzs = ClassHandler.getClass(field.getValuegetclass());
        Iterator<Class<?>> iterator = clazzs.iterator();
        if (iterator.hasNext()) {
            Class<?> clazz = iterator.next();
            Object object = clazz.newInstance();
            if (object instanceof IValueGet) {
                IValueGet get = (IValueGet)object;
                return get.get(new ValueGetParam(this.service, field, this.param, data));
            }
            throw new Exception(clazz + " not extends " + IValueGet.class.getName());
        }
        return null;
    }
}

