/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.config;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutorService;
import javax.servlet.Filter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizationRequestRedirectFilter;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.security.web.authentication.rememberme.PersistentTokenBasedRememberMeServices;
import top.dcenter.ums.security.core.oauth.config.Auth2AutoConfiguration;
import top.dcenter.ums.security.core.oauth.filter.login.Auth2LoginAuthenticationFilter;
import top.dcenter.ums.security.core.oauth.filter.redirect.Auth2DefaultRequestRedirectFilter;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.oauth.provider.Auth2LoginAuthenticationProvider;
import top.dcenter.ums.security.core.oauth.repository.UsersConnectionRepository;
import top.dcenter.ums.security.core.oauth.service.Auth2UserService;
import top.dcenter.ums.security.core.oauth.service.UmsUserDetailsService;
import top.dcenter.ums.security.core.oauth.signup.ConnectionService;

@Configuration
@ConditionalOnProperty(prefix="ums.oauth", name={"enabled"}, havingValue="true")
@AutoConfigureAfter(value={Auth2AutoConfiguration.class})
public class Auth2AutoConfigurer
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity>
implements InitializingBean {
    private final Auth2Properties auth2Properties;
    private final UmsUserDetailsService umsUserDetailsService;
    private final Auth2UserService auth2UserService;
    private final UsersConnectionRepository usersConnectionRepository;
    private final ConnectionService connectionSignUp;
    private final ExecutorService updateConnectionTaskExecutor;
    @Autowired(required=false)
    private AuthenticationFailureHandler authenticationFailureHandler;
    @Autowired(required=false)
    private AuthenticationSuccessHandler authenticationSuccessHandler;
    @Autowired(required=false)
    private PersistentTokenBasedRememberMeServices persistentTokenBasedRememberMeServices;

    public Auth2AutoConfigurer(Auth2Properties auth2Properties, UmsUserDetailsService umsUserDetailsService, Auth2UserService auth2UserService, UsersConnectionRepository usersConnectionRepository, ConnectionService connectionSignUp, @Qualifier(value="updateConnectionTaskExecutor") ExecutorService updateConnectionTaskExecutor) {
        this.auth2Properties = auth2Properties;
        this.umsUserDetailsService = umsUserDetailsService;
        this.auth2UserService = auth2UserService;
        this.usersConnectionRepository = usersConnectionRepository;
        this.connectionSignUp = connectionSignUp;
        this.updateConnectionTaskExecutor = updateConnectionTaskExecutor;
    }

    public void configure(HttpSecurity http) {
        String authorizationRequestBaseUri = this.auth2Properties.getAuthLoginUrlPrefix();
        Auth2DefaultRequestRedirectFilter auth2DefaultRequestRedirectFilter = new Auth2DefaultRequestRedirectFilter(authorizationRequestBaseUri);
        http.addFilterAfter((Filter)auth2DefaultRequestRedirectFilter, AbstractPreAuthenticatedProcessingFilter.class);
        String filterProcessesUrl = this.auth2Properties.getRedirectUrlPrefix();
        Auth2LoginAuthenticationFilter auth2LoginAuthenticationFilter = new Auth2LoginAuthenticationFilter(filterProcessesUrl);
        AuthenticationManager sharedObject = (AuthenticationManager)http.getSharedObject(AuthenticationManager.class);
        auth2LoginAuthenticationFilter.setAuthenticationManager(sharedObject);
        if (this.authenticationFailureHandler != null) {
            auth2LoginAuthenticationFilter.setAuthenticationFailureHandler(this.authenticationFailureHandler);
        }
        if (this.authenticationSuccessHandler != null) {
            auth2LoginAuthenticationFilter.setAuthenticationSuccessHandler(this.authenticationSuccessHandler);
        }
        if (this.persistentTokenBasedRememberMeServices != null) {
            auth2LoginAuthenticationFilter.setRememberMeServices((RememberMeServices)this.persistentTokenBasedRememberMeServices);
        }
        http.addFilterAfter((Filter)this.postProcess((Object)auth2LoginAuthenticationFilter), OAuth2AuthorizationRequestRedirectFilter.class);
        Auth2LoginAuthenticationProvider auth2LoginAuthenticationProvider = new Auth2LoginAuthenticationProvider(this.auth2UserService, this.connectionSignUp, this.umsUserDetailsService, this.usersConnectionRepository, this.updateConnectionTaskExecutor);
        http.authenticationProvider((AuthenticationProvider)this.postProcess(auth2LoginAuthenticationProvider));
    }

    private static void disableAccessWarnings() {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field field = unsafeClass.getDeclaredField("theUnsafe");
            field.setAccessible(true);
            Object unsafe = field.get(null);
            Method putObjectVolatile = unsafeClass.getDeclaredMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class);
            Method staticFieldOffset = unsafeClass.getDeclaredMethod("staticFieldOffset", Field.class);
            Class<?> loggerClass = Class.forName("jdk.internal.module.IllegalAccessLogger");
            Field loggerField = loggerClass.getDeclaredField("logger");
            Long offset = (Long)staticFieldOffset.invoke(unsafe, loggerField);
            putObjectVolatile.invoke(unsafe, loggerClass, offset, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void afterPropertiesSet() {
        if (this.auth2Properties.getSuppressReflectWarning().booleanValue()) {
            Auth2AutoConfigurer.disableAccessWarnings();
        }
    }
}

