/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.justauth;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import me.zhyd.oauth.cache.AuthDefaultStateCache;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.lang.NonNull;
import top.dcenter.ums.security.core.oauth.justauth.cache.AuthStateRedisCache;
import top.dcenter.ums.security.core.oauth.justauth.cache.AuthStateSessionCache;
import top.dcenter.ums.security.core.oauth.justauth.enums.StateCacheType;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2AlipayRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2AliyunRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2BaiduRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2CodingRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2CsdnRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2DefaultRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2DingTalkRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2DouyinRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2ElemeRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2FacebookRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2FeishuRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2GiteeRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2GithubRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2GitlabRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2GoogleRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2HuaweiRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2JdRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2KujialeRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2LinkedinRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2MeituanRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2MiRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2MicrosoftRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2OschinaRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2PinterestRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2QqRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2RenrenRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2StackOverflowRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2TaobaoRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2TeambitionRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2ToutiaoRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2TwitterRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2WeChatEnterpriseRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2WeChatMpRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2WeChatOpenRequest;
import top.dcenter.ums.security.core.oauth.justauth.request.Auth2WeiboRequest;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.oauth.properties.BaseAuth2Properties;
import top.dcenter.ums.security.core.oauth.properties.JustAuthProperties;
import top.dcenter.ums.security.core.oauth.util.MvcUtil;

public class Auth2RequestHolder
implements InitializingBean,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(Auth2RequestHolder.class);
    private static final String FIELD_SEPARATOR = "_";
    private static final String CLIENT_ID_FIELD_NAME = "clientId";
    private static final String CLIENT_SECRET_FIELD_NAME = "clientSecret";
    private static final String PROVIDER_ID_FIELD_NAME = "providerId";
    private static final Map<String, Auth2DefaultRequest> PROVIDER_ID_AUTH_REQUEST_MAP = new ConcurrentHashMap<String, Auth2DefaultRequest>();
    private static final Map<AuthDefaultSource, String> SOURCE_PROVIDER_ID_MAP = new ConcurrentHashMap<AuthDefaultSource, String>();
    private ApplicationContext applicationContext;

    public static Auth2DefaultRequest getAuth2DefaultRequest(String providerId) {
        if (PROVIDER_ID_AUTH_REQUEST_MAP.size() < 1 || providerId == null) {
            return null;
        }
        return PROVIDER_ID_AUTH_REQUEST_MAP.get(providerId);
    }

    public static String getProviderId(AuthDefaultSource source) {
        if (SOURCE_PROVIDER_ID_MAP.size() < 1 || null == source) {
            return null;
        }
        return SOURCE_PROVIDER_ID_MAP.get(source);
    }

    public static Collection<String> getProviderIds() {
        return SOURCE_PROVIDER_ID_MAP.values();
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        Field[] declaredFields;
        Auth2Properties auth2Properties = (Auth2Properties)this.applicationContext.getBean(Auth2Properties.class);
        JustAuthProperties justAuthProperties = auth2Properties.getJustAuth();
        StateCacheType stateCacheType = justAuthProperties.getCacheType();
        StringRedisTemplate stringRedisTemplate = (StringRedisTemplate)this.applicationContext.getBean(StringRedisTemplate.class);
        AuthStateCache authStateCache = this.getAuthStateCache(stateCacheType, auth2Properties, stringRedisTemplate);
        Class<?> aClass = auth2Properties.getClass();
        for (Field field : declaredFields = aClass.getDeclaredFields()) {
            field.setAccessible(true);
            Object baseProperties = field.get(auth2Properties);
            if (!(baseProperties instanceof BaseAuth2Properties)) continue;
            String providerId = field.getName();
            CharSequence[] splits = StringUtils.splitByCharacterTypeCamelCase((String)providerId);
            AuthDefaultSource source = AuthDefaultSource.valueOf((String)String.join((CharSequence)FIELD_SEPARATOR, splits).toUpperCase());
            SOURCE_PROVIDER_ID_MAP.put(source, providerId);
            BaseAuth2Properties baseAuth2Properties = (BaseAuth2Properties)baseProperties;
            if (baseAuth2Properties.getClientId() == null || baseAuth2Properties.getClientSecret() == null) continue;
            Auth2DefaultRequest auth2DefaultRequest = this.getAuth2DefaultRequest(source, auth2Properties, authStateCache);
            PROVIDER_ID_AUTH_REQUEST_MAP.put(providerId, auth2DefaultRequest);
        }
    }

    private Auth2DefaultRequest getAuth2DefaultRequest(@NonNull AuthDefaultSource source, @NonNull Auth2Properties auth2Properties, @NonNull AuthStateCache authStateCache) throws IllegalAccessException {
        JustAuthProperties justAuth = auth2Properties.getJustAuth();
        AuthConfig config = this.getAuthConfig(auth2Properties, source);
        config.setScopes(justAuth.getScopes());
        Auth2Properties.HttpConfigProperties proxy = auth2Properties.getProxy();
        config.setHttpConfig(proxy.getHttpConfig());
        config.setIgnoreCheckState(justAuth.getIgnoreCheckState().booleanValue());
        switch (source) {
            case GITHUB: {
                config.getHttpConfig().setTimeout((int)proxy.getForeignTimeout().toMillis());
                return new Auth2GithubRequest(config, authStateCache);
            }
            case WEIBO: {
                return new Auth2WeiboRequest(config, authStateCache);
            }
            case GITEE: {
                return new Auth2GiteeRequest(config, authStateCache);
            }
            case DINGTALK: {
                return new Auth2DingTalkRequest(config, authStateCache);
            }
            case BAIDU: {
                return new Auth2BaiduRequest(config, authStateCache);
            }
            case CSDN: {
                return new Auth2CsdnRequest(config, authStateCache);
            }
            case CODING: {
                config.setCodingGroupName(auth2Properties.getCoding().getCodingGroupName());
                return new Auth2CodingRequest(config, authStateCache);
            }
            case OSCHINA: {
                return new Auth2OschinaRequest(config, authStateCache);
            }
            case ALIPAY: {
                config.setAlipayPublicKey(auth2Properties.getAlipay().getAlipayPublicKey());
                return new Auth2AlipayRequest(config, authStateCache);
            }
            case QQ: {
                config.setUnionId(auth2Properties.getQq().getUnionId().booleanValue());
                return new Auth2QqRequest(config, authStateCache);
            }
            case WECHAT_OPEN: {
                return new Auth2WeChatOpenRequest(config, authStateCache);
            }
            case WECHAT_MP: {
                return new Auth2WeChatMpRequest(config, authStateCache);
            }
            case TAOBAO: {
                return new Auth2TaobaoRequest(config, authStateCache);
            }
            case GOOGLE: {
                config.getHttpConfig().setTimeout((int)proxy.getForeignTimeout().toMillis());
                return new Auth2GoogleRequest(config, authStateCache);
            }
            case FACEBOOK: {
                config.getHttpConfig().setTimeout((int)proxy.getForeignTimeout().toMillis());
                return new Auth2FacebookRequest(config, authStateCache);
            }
            case DOUYIN: {
                return new Auth2DouyinRequest(config, authStateCache);
            }
            case LINKEDIN: {
                return new Auth2LinkedinRequest(config, authStateCache);
            }
            case MICROSOFT: {
                config.getHttpConfig().setTimeout((int)proxy.getForeignTimeout().toMillis());
                return new Auth2MicrosoftRequest(config, authStateCache);
            }
            case MI: {
                return new Auth2MiRequest(config, authStateCache);
            }
            case TOUTIAO: {
                return new Auth2ToutiaoRequest(config, authStateCache);
            }
            case TEAMBITION: {
                return new Auth2TeambitionRequest(config, authStateCache);
            }
            case RENREN: {
                return new Auth2RenrenRequest(config, authStateCache);
            }
            case PINTEREST: {
                config.getHttpConfig().setTimeout((int)proxy.getForeignTimeout().toMillis());
                return new Auth2PinterestRequest(config, authStateCache);
            }
            case STACK_OVERFLOW: {
                config.getHttpConfig().setTimeout((int)proxy.getForeignTimeout().toMillis());
                config.setStackOverflowKey(auth2Properties.getStackOverflow().getStackOverflowKey());
                return new Auth2StackOverflowRequest(config, authStateCache);
            }
            case HUAWEI: {
                return new Auth2HuaweiRequest(config, authStateCache);
            }
            case WECHAT_ENTERPRISE: {
                config.setAgentId(auth2Properties.getWechatEnterprise().getAgentId());
                return new Auth2WeChatEnterpriseRequest(config, authStateCache);
            }
            case KUJIALE: {
                return new Auth2KujialeRequest(config, authStateCache);
            }
            case GITLAB: {
                config.getHttpConfig().setTimeout((int)proxy.getForeignTimeout().toMillis());
                return new Auth2GitlabRequest(config, authStateCache);
            }
            case MEITUAN: {
                return new Auth2MeituanRequest(config, authStateCache);
            }
            case ELEME: {
                return new Auth2ElemeRequest(config, authStateCache);
            }
            case TWITTER: {
                config.getHttpConfig().setTimeout((int)proxy.getForeignTimeout().toMillis());
                return new Auth2TwitterRequest(config, authStateCache);
            }
            case FEISHU: {
                return new Auth2FeishuRequest(config, authStateCache);
            }
            case JD: {
                return new Auth2JdRequest(config, authStateCache);
            }
            case ALIYUN: {
                return new Auth2AliyunRequest(config, authStateCache);
            }
        }
        return null;
    }

    private AuthStateCache getAuthStateCache(StateCacheType type, Auth2Properties auth2Properties, StringRedisTemplate stringRedisTemplate) {
        switch (type) {
            case DEFAULT: {
                return AuthDefaultStateCache.INSTANCE;
            }
            case SESSION: {
                return new AuthStateSessionCache(auth2Properties);
            }
            case REDIS: {
                if (stringRedisTemplate == null) {
                    log.error("applicationContext \u4e2d\u83b7\u53d6\u4e0d\u5230 {}, {} \u7c7b\u578b\u7684\u7f13\u5b58\u65e0\u6cd5\u521b\u5efa, \u7528 {} \u7c7b\u578b\u7f13\u5b58\u66ff\u4ee3", new Object[]{StringRedisTemplate.class.getName(), type.name(), StateCacheType.DEFAULT.name()});
                    return AuthDefaultStateCache.INSTANCE;
                }
                return new AuthStateRedisCache(auth2Properties, stringRedisTemplate);
            }
        }
        log.error("{} \u7c7b\u578b\u4e0d\u5339\u914d, \u4f7f\u7528 {} \u7c7b\u578b\u7f13\u5b58\u66ff\u4ee3", (Object)StateCacheType.class.getName(), (Object)StateCacheType.DEFAULT.name());
        return AuthDefaultStateCache.INSTANCE;
    }

    private AuthConfig getAuthConfig(@NonNull Auth2Properties auth2Properties, @NonNull AuthDefaultSource source) throws IllegalAccessException, NullPointerException {
        AuthConfig.AuthConfigBuilder builder = AuthConfig.builder();
        String fieldName = Auth2RequestHolder.getProviderId(source);
        Class<?> aClass = auth2Properties.getClass();
        Field[] declaredFields = aClass.getDeclaredFields();
        Object providerProperties = null;
        for (Field field : declaredFields) {
            field.setAccessible(true);
            if (!StringUtils.equals((CharSequence)fieldName, (CharSequence)field.getName())) continue;
            providerProperties = field.get(auth2Properties);
            break;
        }
        String providerId = "";
        Objects.requireNonNull(providerProperties, String.format("\u83b7\u53d6\u4e0d\u5230 %s \u7c7b\u578b\u6240\u5bf9\u5e94\u7684 BaseAuth2Properties \u7684\u5b50\u7c7b", source.name()));
        for (Field field : declaredFields = providerProperties.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            if (!StringUtils.equals((CharSequence)PROVIDER_ID_FIELD_NAME, (CharSequence)field.getName())) continue;
            providerId = (String)field.get(providerProperties);
            Objects.requireNonNull(providerId, String.format("\u83b7\u53d6\u4e0d\u5230 %s \u7c7b\u578b\u6240\u5bf9\u5e94\u7684 %s \u7684\u503c", source.name(), PROVIDER_ID_FIELD_NAME));
        }
        Class<BaseAuth2Properties> baseClass = BaseAuth2Properties.class;
        for (Field field : declaredFields = baseClass.getDeclaredFields()) {
            field.setAccessible(true);
            if (StringUtils.equals((CharSequence)CLIENT_ID_FIELD_NAME, (CharSequence)field.getName())) {
                String clientId = (String)field.get(providerProperties);
                Objects.requireNonNull(clientId, String.format("\u83b7\u53d6\u4e0d\u5230 %s \u7c7b\u578b\u6240\u5bf9\u5e94\u7684 %s \u7684\u503c", source.name(), CLIENT_ID_FIELD_NAME));
                builder.clientId(clientId);
            }
            if (!StringUtils.equals((CharSequence)CLIENT_SECRET_FIELD_NAME, (CharSequence)field.getName())) continue;
            String clientSecret = (String)field.get(providerProperties);
            Objects.requireNonNull(clientSecret, String.format("\u83b7\u53d6\u4e0d\u5230 %s \u7c7b\u578b\u6240\u5bf9\u5e94\u7684 %s \u7684\u503c", source.name(), CLIENT_SECRET_FIELD_NAME));
            builder.clientSecret(clientSecret);
        }
        String redirectUri = auth2Properties.getDomain() + MvcUtil.getServletContextPath() + auth2Properties.getRedirectUrlPrefix() + "/" + providerId;
        return builder.redirectUri(redirectUri).build();
    }

    public static String getProviderIdBySource(@NonNull AuthDefaultSource source) {
        String name = source.name().toLowerCase();
        String[] splits = StringUtils.splitByWholeSeparator((String)name, (String)FIELD_SEPARATOR);
        Object fieldName = name;
        if (splits.length > 1) {
            String secondName = splits[1];
            fieldName = splits[0] + secondName.substring(0, 1).toUpperCase() + secondName.substring(1);
        }
        return fieldName;
    }
}

