/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.repository.jdbc.cache;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.Callable;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;
import org.springframework.cache.Cache;
import org.springframework.cache.support.NullValue;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import top.dcenter.ums.security.core.oauth.repository.jdbc.cache.RedisHashCacheWriter;

public class RedisHashCache
extends RedisCache {
    private static final byte[] BINARY_NULL_VALUE = RedisSerializer.java().serialize(NullValue.INSTANCE);
    private static final int HASH_KEY_ARRAY_LENGTH = 2;
    private final String name;
    private final RedisHashCacheWriter cacheWriter;
    private final RedisCacheConfiguration cacheConfig;
    private final ConversionService conversionService;

    protected RedisHashCache(String name, RedisHashCacheWriter cacheWriter, RedisCacheConfiguration cacheConfig) {
        super(name, (RedisCacheWriter)cacheWriter, cacheConfig);
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
        Assert.notNull((Object)cacheConfig, (String)"CacheConfig must not be null!");
        this.name = name;
        this.cacheWriter = cacheWriter;
        this.cacheConfig = cacheConfig;
        this.conversionService = cacheConfig.getConversionService();
    }

    protected Object lookup(@NonNull Object key) {
        Object[] keyPair = this.parsingKey(key);
        byte[] value = keyPair.length == 2 ? this.cacheWriter.hGet(this.name, this.createAndConvertCacheKey(keyPair[0]), this.createAndConvertCacheField(keyPair[1])) : this.cacheWriter.get(this.name, this.createAndConvertCacheKey(key));
        if (value == null) {
            return null;
        }
        return this.deserializeCacheValue(value);
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public RedisCacheWriter getNativeCache() {
        return this.cacheWriter;
    }

    public synchronized <T> T get(@NonNull Object key, @NonNull Callable<T> valueLoader) {
        Cache.ValueWrapper result = this.get(key);
        if (result != null) {
            return (T)result.get();
        }
        T value = RedisHashCache.valueFromLoader(key, valueLoader);
        this.put(key, value);
        return value;
    }

    public void put(@NonNull Object key, @Nullable Object value) {
        Object cacheValue = this.preProcessCacheValue(value);
        if (!this.isAllowNullValues() && cacheValue == null) {
            throw new IllegalArgumentException(String.format("Cache '%s' does not allow 'null' values. Avoid storing null via '@Cacheable(unless=\"#result == null\")' or configure RedisCache to allow 'null' via RedisCacheConfiguration.", this.name));
        }
        Object[] keyPair = this.parsingKey(key);
        if (keyPair.length == 2) {
            this.cacheWriter.hPut(this.name, this.createAndConvertCacheKey(keyPair[0]), this.createAndConvertCacheField(keyPair[1]), this.serializeCacheValue(cacheValue), this.getRandomTtl(this.cacheConfig.getTtl()));
        } else {
            this.cacheWriter.put(this.name, this.createAndConvertCacheKey(key), this.serializeCacheValue(cacheValue), this.getRandomTtl(this.cacheConfig.getTtl()));
        }
    }

    public Cache.ValueWrapper putIfAbsent(@NonNull Object key, @Nullable Object value) {
        Object cacheValue = this.preProcessCacheValue(value);
        if (!this.isAllowNullValues() && cacheValue == null) {
            return this.get(key);
        }
        Object[] keyPair = this.parsingKey(key);
        byte[] result = keyPair.length == 2 ? this.cacheWriter.hPutIfAbsent(this.name, this.createAndConvertCacheKey(keyPair[0]), this.createAndConvertCacheField(keyPair[1]), this.serializeCacheValue(cacheValue), this.getRandomTtl(this.cacheConfig.getTtl())) : this.cacheWriter.putIfAbsent(this.name, this.createAndConvertCacheKey(key), this.serializeCacheValue(cacheValue), this.getRandomTtl(this.cacheConfig.getTtl()));
        if (result == null) {
            return null;
        }
        return new SimpleValueWrapper(this.fromStoreValue(this.deserializeCacheValue(result)));
    }

    public void evict(@NonNull Object key) {
        Object[] keyPair = this.parsingKey(key);
        if (keyPair.length == 2) {
            this.cacheWriter.hRemove(this.name, this.createAndConvertCacheKey(keyPair[0]), this.createAndConvertCacheField(keyPair[1]));
            return;
        }
        this.cacheWriter.remove(this.name, this.createAndConvertCacheKey(key));
    }

    public void clear() {
        byte[] pattern = (byte[])this.conversionService.convert((Object)this.createCacheKey("*"), byte[].class);
        this.cacheWriter.clean(this.name, pattern);
    }

    @NonNull
    public RedisCacheConfiguration getCacheConfiguration() {
        return this.cacheConfig;
    }

    @Nullable
    protected Object preProcessCacheValue(@Nullable Object value) {
        if (value != null) {
            return value;
        }
        return this.isAllowNullValues() ? NullValue.INSTANCE : null;
    }

    @NonNull
    protected byte[] serializeCacheKey(@NonNull String cacheKey) {
        return ByteUtils.getBytes((ByteBuffer)this.cacheConfig.getKeySerializationPair().write((Object)cacheKey));
    }

    @NonNull
    protected byte[] serializeCacheValue(@Nullable Object value) {
        if (this.isAllowNullValues() && value instanceof NullValue) {
            return BINARY_NULL_VALUE;
        }
        return ByteUtils.getBytes((ByteBuffer)this.cacheConfig.getValueSerializationPair().write(value));
    }

    @Nullable
    protected Object deserializeCacheValue(@NonNull byte[] value) {
        if (this.isAllowNullValues() && ObjectUtils.nullSafeEquals((Object)value, (Object)BINARY_NULL_VALUE)) {
            return NullValue.INSTANCE;
        }
        return this.cacheConfig.getValueSerializationPair().read(ByteBuffer.wrap(value));
    }

    @NonNull
    protected String createCacheKey(@NonNull Object key) {
        String convertedKey = this.convertKey(key);
        if (!this.cacheConfig.usePrefix()) {
            return convertedKey;
        }
        return this.prefixCacheKey(convertedKey);
    }

    @NonNull
    protected String convertKey(@NonNull Object key) {
        TypeDescriptor target;
        if (key instanceof String) {
            return (String)key;
        }
        TypeDescriptor source = TypeDescriptor.forObject((Object)key);
        if (this.conversionService.canConvert(source, target = TypeDescriptor.valueOf(String.class))) {
            try {
                String convert = (String)this.conversionService.convert(key, String.class);
                if (StringUtils.isBlank((CharSequence)convert)) {
                    throw new ConversionFailedException(source, target, key, (Throwable)new RuntimeException("convert is null"));
                }
                return convert;
            }
            catch (ConversionFailedException e) {
                if (this.isCollectionLikeOrMap(source)) {
                    return this.convertCollectionLikeOrMapKey(key, source);
                }
                throw e;
            }
        }
        Method toString = ReflectionUtils.findMethod(key.getClass(), (String)"toString");
        if (toString != null && !Object.class.equals(toString.getDeclaringClass())) {
            return key.toString();
        }
        throw new IllegalStateException(String.format("Cannot convert cache key %s to String. Please register a suitable Converter via 'RedisCacheConfiguration.configureKeyConverters(...)' or override '%s.toString()'.", source, key.getClass().getSimpleName()));
    }

    private Duration getRandomTtl(Duration ttl) {
        if (ttl.getSeconds() == 0L) {
            return ttl;
        }
        int randomRange = (int)(ttl.getSeconds() * 2L / 10L);
        ThreadLocalRandom localRandom = ThreadLocalRandom.current();
        Duration randomTtl = localRandom.nextBoolean() ? Duration.ofSeconds(ttl.getSeconds()).minusSeconds(localRandom.nextInt(randomRange)) : Duration.ofSeconds(ttl.getSeconds()).plusSeconds(localRandom.nextInt(randomRange));
        return randomTtl;
    }

    private Object[] parsingKey(Object key) {
        if (key instanceof String) {
            return StringUtils.splitByWholeSeparator((String)((String)key), (String)"__");
        }
        return new Object[]{key};
    }

    private String convertCollectionLikeOrMapKey(Object key, TypeDescriptor source) {
        if (source.isMap()) {
            StringBuilder target = new StringBuilder("{");
            for (Map.Entry entry : ((Map)key).entrySet()) {
                target.append(this.convertKey(entry.getKey())).append("=").append(this.convertKey(entry.getValue()));
            }
            target.append("}");
            return target.toString();
        }
        if (source.isCollection() || source.isArray()) {
            StringJoiner sj = new StringJoiner(",");
            List<Object> collection = source.isCollection() ? (List<Object>)key : Arrays.asList(ObjectUtils.toObjectArray((Object)key));
            for (Object e : collection) {
                sj.add(this.convertKey(e));
            }
            return "[" + sj.toString() + "]";
        }
        throw new IllegalArgumentException(String.format("Cannot convert cache key %s to String.", key));
    }

    private boolean isCollectionLikeOrMap(TypeDescriptor source) {
        return source.isArray() || source.isCollection() || source.isMap();
    }

    private byte[] createAndConvertCacheKey(Object key) {
        return this.serializeCacheKey(this.createCacheKey(key));
    }

    private byte[] createAndConvertCacheField(Object field) {
        return this.serializeCacheKey(this.convertKey(field));
    }

    private String prefixCacheKey(String key) {
        return this.cacheConfig.getKeyPrefixFor(this.name) + key;
    }

    private static <T> T valueFromLoader(Object key, Callable<T> valueLoader) {
        try {
            return valueLoader.call();
        }
        catch (Exception e) {
            throw new Cache.ValueRetrievalException(key, valueLoader, (Throwable)e);
        }
    }
}

