/*
 * Decompiled with CFR 0.152.
 */
package top.dcenter.ums.security.core.oauth.justauth.cache;

import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import top.dcenter.ums.security.core.oauth.justauth.cache.Auth2StateCache;
import top.dcenter.ums.security.core.oauth.justauth.enums.CacheKeyStrategy;
import top.dcenter.ums.security.core.oauth.properties.Auth2Properties;
import top.dcenter.ums.security.core.oauth.properties.JustAuthProperties;

public class AuthStateRedisCache
implements Auth2StateCache {
    private final JustAuthProperties justAuthProperties;
    private final StringRedisTemplate stringRedisTemplate;

    public AuthStateRedisCache(Auth2Properties auth2Properties, Object stringRedisTemplate) {
        this.justAuthProperties = auth2Properties.getJustAuth();
        this.stringRedisTemplate = (StringRedisTemplate)stringRedisTemplate;
    }

    public void cache(String key, String value) {
        this.cache(key, value, this.justAuthProperties.getTimeout().toMillis());
    }

    public void cache(String key, String value, long timeout) {
        this.stringRedisTemplate.opsForValue().set((Object)(this.justAuthProperties.getCacheKeyPrefix() + key), (Object)value, timeout);
    }

    public String get(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)(this.justAuthProperties.getCacheKeyPrefix() + key));
    }

    public boolean containsKey(String key) {
        return StringUtils.isNotBlank((CharSequence)((CharSequence)this.stringRedisTemplate.opsForValue().get((Object)key)));
    }

    @Override
    public CacheKeyStrategy getCacheKeyStrategy() {
        return CacheKeyStrategy.UUID;
    }
}

